/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.constants.StateAbbreviationType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxConverter;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.constants.VehiclesTaxQuotaType;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.constants.VehiclesTaxType;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTax;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxDebits;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListAll;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.JsonNode;
import org.json.JSONObject;

public class SantanderVehiclesConv
extends BankJsonConverter
implements VehiclesTaxConverter {
    private VehiclesTax convertNode(JsonNode root, EnvironmentType environmentType) {
        VehiclesTax ag = new VehiclesTax();
        ag.setWorkspaceId(this.asText(root, "workspaceId"));
        ag.setVehiclesTaxId(this.asText(root, "id"));
        JsonNode debitAccount = root.findValue("debitAccount");
        if (debitAccount != null) {
            VehiclesTax.Account account = new VehiclesTax.Account();
            account.setBranch(this.asText(debitAccount, "branch"));
            account.setNumber(this.asText(debitAccount, "number"));
            ag.setDebitAccount(account);
        }
        ag.setStatus(this.asText(root, "status"));
        ag.setRejectReason(this.asText(root, "rejectReason"));
        ag.setTags(this.asStringList(root, "tags"));
        VehiclesTax.Owner owner = new VehiclesTax.Owner();
        owner.setName(this.asText(root, "owner"));
        owner.setDocumentNumber(this.asText(root, "documentNumber"));
        if (Objects.equals(this.asText(root, "documentType"), DocumentType.CNPJ.getValue())) {
            owner.setDocumentType(DocumentType.CNPJ);
        } else {
            owner.setDocumentType(DocumentType.CPF);
        }
        ag.setOwner(owner);
        ag.setLicensePlate(this.asText(root, "licensePlate"));
        ag.setQuotaType(VehiclesTaxQuotaType.get(this.asText(root, "typeQuota")));
        ag.setStateType(StateAbbreviationType.get(this.asText(root, "stateAbbreviation")));
        ag.setRenavam(this.asText(root, "renavam"));
        ag.setTaxType(VehiclesTaxType.get(this.asText(root, "taxType")));
        ag.setExerciseYear(this.asInt(root, "exerciseYear"));
        ag.setPaymentDate(this.asLocalDate(root, "paymentDate", UtilDate.Mask.TRACE_FORMATTER));
        ag.setPaymentValue(this.asDouble(root, "paymentValue"));
        JsonNode transactionNode = root.findValue("transaction");
        if (transactionNode != null) {
            Double valueTransaction = this.asDouble(transactionNode, "value");
            String codeTransaction = this.asText(transactionNode, "code");
            LocalDateTime dateTransaction = this.asLocalDateTime(transactionNode, "date");
            VehiclesTax.Transaction acc = new VehiclesTax.Transaction();
            acc.setValue(valueTransaction);
            acc.setTransactionCode(codeTransaction);
            acc.setTransactionDate(dateTransaction);
            ag.setTransaction(acc);
        }
        List<JsonNode> quotasNode = this.asList(root, "quotas");
        LinkedList<VehiclesTax.Quota> quotas = new LinkedList<VehiclesTax.Quota>();
        for (JsonNode jsonNode : quotasNode) {
            VehiclesTax.Quota v = new VehiclesTax.Quota();
            v.setDueDate(this.asLocalDate(jsonNode, "dueDate", UtilDate.Mask.TRACE_FORMATTER));
            v.setValue(this.asDouble(jsonNode, "value"));
            v.setPayed(this.asBoolean(jsonNode, "payed"));
            v.setQuotaType(VehiclesTaxQuotaType.get(this.asText(jsonNode, "typeQuota")));
            quotas.add(v);
        }
        ag.setQuotas(quotas);
        return ag;
    }

    @Override
    public String objectToTextConfirmation(VehiclesTaxParams params, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("status", (Object)params.getStatusType());
        if (params.getDebitAccount() != null) {
            JSONObject account = new JSONObject();
            account.put("branch", (Object)params.getDebitAccount().getBranch());
            account.put("number", (Object)params.getDebitAccount().getNumber());
            root.put("debitAccount", (Object)account);
        }
        return root.toString();
    }

    @Override
    public String objectToText(VehiclesTaxParams params, EnvironmentType environmentType) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)params.getVehiclesTaxId());
        root.put("renavam", (Object)params.getRenavam());
        root.put("taxType", (Object)params.getTaxType().getValue());
        root.put("exerciseYear", (Object)params.getExerciseYear());
        root.put("stateAbbreviation", (Object)params.getStateType().getValue());
        if (params.getOwner() != null) {
            root.put("docType", (Object)params.getOwner().getDocumentType().getValue());
            root.put("documentNumber", (Object)params.getOwner().getDocumentNumber());
        }
        root.put("quotaType", (Object)params.getQuotaType().getValue());
        root.put("paymentDate", (Object)UtilDate.dateToStr(params.getPaymentDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("tags", params.getTags());
        return root.toString();
    }

    @Override
    public VehiclesTax textToVehiclesTax(String data, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(data);
        return this.convertNode(root, environmentType);
    }

    @Override
    public VehiclesTaxListAll textToVehiclesTaxListAll(String json, EnvironmentType environmentType) throws BankException {
        VehiclesTaxListAll aux = new VehiclesTaxListAll();
        JsonNode root = this.getRoot(json);
        Pageable page = new Pageable();
        page.setOffset(this.asInt(root, "_offset"));
        page.setPageNumber(this.asInt(root, "_pageNumber"));
        page.setPageElements(this.asInt(root, "_pageElements"));
        page.setTotalPages(this.asInt(root, "_totalPages"));
        page.setTotalElements(this.asInt(root, "_totalElements"));
        aux.setPageable(page);
        List<JsonNode> content = this.asList(root, "_content");
        LinkedList<VehiclesTax> temp = new LinkedList<VehiclesTax>();
        for (JsonNode jsonNode : content) {
            temp.add(this.convertNode(jsonNode, environmentType));
        }
        aux.setTaxes(temp);
        return aux;
    }

    @Override
    public VehiclesTaxDebits textToVehiclesTaxDebits(String json, EnvironmentType environmentType) throws BankException {
        VehiclesTaxDebits aux = new VehiclesTaxDebits();
        JsonNode root = this.getRoot(json);
        Pageable page = new Pageable();
        page.setOffset(this.asInt(root, "_offset"));
        page.setPageNumber(this.asInt(root, "_pageNumber"));
        page.setPageElements(this.asInt(root, "_pageElements"));
        page.setTotalPages(this.asInt(root, "_totalPages"));
        page.setTotalElements(this.asInt(root, "_totalElements"));
        aux.setPageable(page);
        List<JsonNode> content = this.asList(root, "_content");
        LinkedList<VehiclesTaxDebits.Tax> temp = new LinkedList<VehiclesTaxDebits.Tax>();
        for (JsonNode jsonNode : content) {
            VehiclesTaxDebits.Tax tax = new VehiclesTaxDebits.Tax();
            tax.setDueDate(this.asLocalDate(jsonNode, "dueDate", UtilDate.Mask.TRACE_FORMATTER));
            tax.setExerciseYear(this.asInt(jsonNode, "exerciseYear"));
            tax.setLicensePlate(this.asText(jsonNode, "licensePlate"));
            tax.setOwnerName(this.asText(jsonNode, "owner"));
            tax.setQuotaType(VehiclesTaxQuotaType.get(this.asText(jsonNode, "quotaType")));
            tax.setRenavam(this.asText(jsonNode, "renavam"));
            tax.setStateAbbreviation(StateAbbreviationType.get(this.asText(jsonNode, "stateAbbreviation")));
            tax.setTaxType(VehiclesTaxType.get(this.asText(jsonNode, "taxType")));
            tax.setValue(this.asDouble(jsonNode, "value"));
            temp.add(tax);
        }
        aux.setTaxes(temp);
        return aux;
    }
}

