/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxConverter;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxInterface;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxURL;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxValid;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander.SantanderValidVehiclesImpl;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander.SantanderVehiclesConv;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander.SantanderVehiclesURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander.constants.SantanderVehiclesStatusType;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTax;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxDebits;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxDebitsParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListAll;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxParams;

public class SantanderVehiclesImpl
extends SantanderBaseConnection
implements VehiclesTaxInterface {
    private final VehiclesTaxConverter converter = new SantanderVehiclesConv();
    private final VehiclesTaxURL urlConverter = new SantanderVehiclesURLImpl();
    private final VehiclesTaxValid validator = new SantanderValidVehiclesImpl();

    @Override
    public ProcessResult<VehiclesTaxParams, VehiclesTax> create(VehiclesTaxParams params) throws BankException {
        VehiclesTax ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (!res.isOk()) {
                return new ProcessResult<VehiclesTaxParams, VehiclesTax>(res);
            }
            ret = this.converter.textToVehiclesTax(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            ret.setStatus(SantanderVehiclesStatusType.AUTHORIZED.getValue());
            url = this.urlConverter.getConfirmUrl(params);
            body = this.converter.objectToTextConfirmation(params, params.getToken().getBankCredentials().getEnvironmentType());
            res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToVehiclesTax(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<VehiclesTaxParams, VehiclesTax>(params, ret, res);
        }
        return new ProcessResult<VehiclesTaxParams, VehiclesTax>(params, contraintValidation);
    }

    @Override
    public ProcessResult<VehiclesTaxListParams, VehiclesTax> list(VehiclesTaxListParams params) throws BankException {
        VehiclesTax ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToVehiclesTax(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<VehiclesTaxListParams, Object>(params, ret, res);
        }
        return new ProcessResult<VehiclesTaxListParams, VehiclesTax>(params, contraintValidation);
    }

    @Override
    public ProcessResult<VehiclesTaxListAllParams, VehiclesTaxListAll> listAll(VehiclesTaxListAllParams params) throws BankException {
        VehiclesTaxListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToVehiclesTaxListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<VehiclesTaxListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<VehiclesTaxListAllParams, VehiclesTaxListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String urlConfig = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, urlConfig);
    }

    @Override
    public ProcessResult<VehiclesTaxDebitsParams, VehiclesTaxDebits> debits(VehiclesTaxDebitsParams params) throws BankException {
        VehiclesTaxDebits ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getDebitsUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToVehiclesTaxDebits(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<VehiclesTaxDebitsParams, Object>(params, ret, res);
        }
        return new ProcessResult<VehiclesTaxDebitsParams, VehiclesTaxDebits>(params, contraintValidation);
    }
}

