/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxURL;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxDebitsParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxParams;
import com.touchcomp.basementorbanks.url.VehiclesTaxPayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderVehiclesURLImpl
implements VehiclesTaxURL {
    private VehiclesTaxPayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getVehiclesTaxURL();
        }
        return new SantanderHomoURL().getVehiclesTaxURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(VehiclesTaxParams params) {
        VehiclesTaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationVehiclesTax(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getConfirmUrl(VehiclesTaxParams params) {
        VehiclesTaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getConfirmVehiclesTax(), params.getWorkspaceId(), params.getVehiclesTaxId());
        return url;
    }

    @Override
    public String getListUrl(VehiclesTaxListParams params) {
        VehiclesTaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getVehiclesTaxList(), params.getWorkspaceId(), params.getVehiclesTaxPaymentId());
        return url;
    }

    @Override
    public String getListAllUrl(VehiclesTaxListAllParams params) {
        VehiclesTaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getVehiclesTaxListAll(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).queryParamIfPresent("initialDate", Optional.ofNullable(params.getInitialDate())).queryParamIfPresent("finalDate", Optional.ofNullable(params.getFinalDate())).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
        return url;
    }

    @Override
    public String getDebitsUrl(VehiclesTaxDebitsParams params) {
        VehiclesTaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getVehiclesTaxDebits(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("renavam", Optional.ofNullable(params.getRenavam())).queryParamIfPresent("stateAbbreviation", Optional.ofNullable(params.getStateAbbreviation().getValue())).build();
        return url;
    }
}

