/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.workspace;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander.SantanderWorkspacePayImpl;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePay;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayDeleteParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayParams;

public class BankWorkspacePayments {
    public ProcessResult<WorkspacePayParams, WorkspacePay> create(WorkspacePayParams workspace) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.createWorkspace(workspace);
    }

    public ProcessResult<WorkspacePayParams, WorkspacePay> update(WorkspacePayParams workspace) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.update(workspace);
    }

    public ProcessBooleanResult<WorkspacePayDeleteParams> delete(WorkspacePayDeleteParams workspace) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.delete(workspace);
    }

    public ProcessResult<WorkspacePayListAllParams, WorkspacePayListAll> listAll(WorkspacePayListAllParams params) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(params.getToken().getBankCredentials());
        return found.listAll(params);
    }

    public ProcessResult<WorkspacePayListParams, WorkspacePay> list(WorkspacePayListParams workspace) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.list(workspace);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        WorkspacePayInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private WorkspacePayInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderWorkspacePayImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

