/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.constants.StatusType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePay;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class SantanderWorkspacePayConverter
extends BankJsonConverter
implements WorkspacePayConverter {
    @Override
    public WorkspacePayListAll textToWorkspaces(String json, EnvironmentType environmentType) throws BankException {
        WorkspacePayListAll aux = new WorkspacePayListAll();
        JsonNode root = this.getRoot(json);
        if (Objects.equals((Object)environmentType, (Object)EnvironmentType.HOMOLOGACAO)) {
            JsonNode pageableNode = root.findValue("_pageable");
            Pageable page = new Pageable();
            page.setOffset(this.asInt(pageableNode, "_offset"));
            page.setPageElements(this.asInt(pageableNode, "_pageElements"));
            page.setPageNumber(this.asInt(pageableNode, "_pageNumber"));
            page.setTotalElements(this.asInt(pageableNode, "_totalElements"));
            page.setTotalPages(this.asInt(pageableNode, "_totalPages"));
            aux.setPageable(page);
            List<JsonNode> content = this.asList(root, "_content");
            LinkedList<WorkspacePay> temp = new LinkedList<WorkspacePay>();
            for (JsonNode jsonNode : content) {
                temp.add(this.convertToWorkspace(jsonNode));
            }
            aux.setWorkspaces(temp);
        } else {
            JsonNode pageableNode = root.findValue("pageable");
            Pageable page = new Pageable();
            page.setOffset(this.asInt(pageableNode, "offset"));
            page.setPageElements(this.asInt(root, "numberOfElements"));
            page.setPageNumber(this.asInt(root, "number"));
            page.setTotalElements(this.asInt(root, "totalElements"));
            page.setTotalPages(this.asInt(root, "totalPages"));
            aux.setPageable(page);
            List<JsonNode> content = this.asList(root, "content");
            LinkedList<WorkspacePay> temp = new LinkedList<WorkspacePay>();
            for (JsonNode jsonNode : content) {
                temp.add(this.convertToWorkspace(jsonNode));
            }
            aux.setWorkspaces(temp);
        }
        return aux;
    }

    @Override
    public WorkspacePay textToWorkspace(String json, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(json);
        return this.convertToWorkspace(root);
    }

    @Override
    public String objectToText(WorkspacePayParams workspace, EnvironmentType environmentType) throws BankException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        if (UtilMethods.isStrWithData(workspace.getWorkspaceId())) {
            root.put("id", workspace.getWorkspaceId());
        }
        root.put("type", workspace.getWorkspaceType());
        ObjectNode mainDebitAccount = mapper.createObjectNode();
        mainDebitAccount.put("branch", workspace.getMainDebitAccount().getBranchNumber());
        mainDebitAccount.put("number", workspace.getMainDebitAccount().getAccountNumber());
        root.put("mainDebitAccount", (JsonNode)mainDebitAccount);
        if (UtilMethods.isWithData(workspace.getAdditionalDebitAccounts())) {
            ArrayNode additionalDebitAccountsNode = mapper.createArrayNode();
            for (WorkspacePayParams.Account account : workspace.getAdditionalDebitAccounts()) {
                ObjectNode accountNode = mapper.createObjectNode();
                accountNode.put("branch", account.getBranchNumber());
                accountNode.put("number", account.getAccountNumber());
                additionalDebitAccountsNode.add((JsonNode)accountNode);
            }
            root.put("additionalDebitAccounts", (JsonNode)additionalDebitAccountsNode);
        }
        ArrayNode tagsNode = mapper.createArrayNode();
        if (UtilMethods.isWithData(workspace.getTags())) {
            for (String tag : workspace.getTags()) {
                tagsNode.add(tag);
            }
            root.put("tags", (JsonNode)tagsNode);
        }
        root.put("description", workspace.getDescription());
        root.put("webhookURL", workspace.getWebhookURL());
        root.put("pixPaymentsActive", workspace.isPixPaymentsActive());
        root.put("bankSlipPaymentsActive", workspace.isBankSlipPaymentsActive());
        root.put("barCodePaymentsActive", workspace.isBarCodePaymentsActive());
        root.put("taxesByFieldPaymentsActive", workspace.isTaxesByFieldPaymentsActive());
        root.put("vehicleTaxesPaymentsActive", workspace.isVehicleTaxesPaymentsActive());
        root.put("bankTransferPaymentsActive", workspace.isBankTransferPaymentsActive());
        root.put("bankSlipAvailableActive", workspace.isBankSlipAvailableActive());
        root.put("bankSlipAvailableWebhookActive", workspace.isBankSlipAvailableWebhookActive());
        root.put("smartTransfersActive", workspace.isSmartTransfersActive());
        return root.toString();
    }

    private WorkspacePay convertToWorkspace(JsonNode root) {
        List nodes;
        WorkspacePay aux = new WorkspacePay();
        aux.setWorkspaceId(this.asText(root, "id"));
        aux.setWorkspaceType(this.asText(root, "type"));
        aux.setCreationDate(this.asDate(root, "creationDate", UtilDate.Mask.TRACE_FORMATTER));
        aux.setDescription(this.asText(root, "description"));
        JsonNode account = root.findValue("mainDebitAccount");
        if (account != null) {
            WorkspacePay.Account main = new WorkspacePay.Account();
            main.setBranchNumber(this.asText(account, "branch"));
            main.setAccountNumber(this.asText(account, "number"));
            aux.setMainDebitAccount(main);
        }
        if ((nodes = root.findValues("addicionalDebitAccounts")) != null) {
            for (JsonNode acc : nodes) {
                WorkspacePay.Account payAux = new WorkspacePay.Account();
                payAux.setBranchNumber(this.asText(acc, "branch"));
                payAux.setAccountNumber(this.asText(acc, "number"));
                aux.getAdditionalDebitAccounts().add(payAux);
            }
        }
        aux.setTags(this.asStringList(root, "tags"));
        if (Objects.equals(this.asText(root, "status"), StatusType.ACTIVE.getType())) {
            aux.setStatusType(StatusType.ACTIVE);
        } else {
            aux.setStatusType(StatusType.ACTIVE);
        }
        aux.setWebhookURL(this.asText(root, "webhookURL"));
        aux.setBankSlipAvailableDDAActive(this.asBoolean(root, "bankSlipAvailableActive"));
        aux.setBankSlipAvailableDDAWebhookActive(this.asBoolean(root, "bankSlipAvailableWebhookActive"));
        aux.setBankSlipPaymentsActive(this.asBoolean(root, "bankSlipPaymentsActive"));
        aux.setBankTransferPaymentsActive(this.asBoolean(root, "bankTransferPaymentsActive"));
        aux.setBarCodePaymentsActive(this.asBoolean(root, "barCodePaymentsActive"));
        aux.setTaxesByFieldPaymentsActive(this.asBoolean(root, "taxesByFieldPaymentsActive"));
        aux.setPixPaymentsActive(this.asBoolean(root, "pixPaymentsActive"));
        aux.setVehicleTaxesPaymentsActive(this.asBoolean(root, "vehicleTaxesPaymentsActive"));
        aux.setSmartTransfersActive(this.asBoolean(root, "smartTransfersActive"));
        return aux;
    }
}

