/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayURL;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayValid;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander.SantanderValidWorkspacePayImpl;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander.SantanderWorkspacePayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander.SantanderWorkspacePayURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePay;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayDeleteParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayParams;
import com.touchcomp.basementorbanks.url.WorkspacePayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;

public class SantanderWorkspacePayImpl
extends SantanderBaseConnection
implements WorkspacePayInterface {
    private final WorkspacePayConverter converter = new SantanderWorkspacePayConverter();
    private final WorkspacePayURL urlConverter = new SantanderWorkspacePayURLImpl();
    private final WorkspacePayValid validator = new SantanderValidWorkspacePayImpl();

    @Override
    public ProcessResult<WorkspacePayParams, WorkspacePay> createWorkspace(WorkspacePayParams params) throws BankException {
        WorkspacePay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToWorkspace(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspacePayParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspacePayParams, WorkspacePay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WorkspacePayParams, WorkspacePay> update(WorkspacePayParams params) throws BankException {
        WorkspacePay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getUpdateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToWorkspace(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspacePayParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspacePayParams, WorkspacePay>(params, contraintValidation);
    }

    @Override
    public ProcessBooleanResult<WorkspacePayDeleteParams> delete(WorkspacePayDeleteParams params) throws BankException {
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getDeleteUrl(params);
            ResponseResult responseResult = this.exchangeDeleteData(params.getToken(), url);
        }
        return new ProcessBooleanResult<WorkspacePayDeleteParams>(params, true, contraintValidation);
    }

    @Override
    public ProcessResult<WorkspacePayListAllParams, WorkspacePayListAll> listAll(WorkspacePayListAllParams params) throws BankException {
        WorkspacePayListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToWorkspaces(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspacePayListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspacePayListAllParams, WorkspacePayListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WorkspacePayListParams, WorkspacePay> list(WorkspacePayListParams params) throws BankException {
        WorkspacePay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToWorkspace(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspacePayListParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspacePayListParams, WorkspacePay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        WorkspacePayURLInterface urlConfig = this.getUrl(credentials.getEnvironmentType());
        return this.getToken(credentials, urlConfig.getAuthUrl());
    }

    private WorkspacePayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getWorkspacePayURL();
        }
        return new SantanderHomoURL().getWorkspacePayURL();
    }
}

