/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.workspace.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.WorkspacePayURL;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayDeleteParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayParams;
import com.touchcomp.basementorbanks.url.WorkspacePayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderWorkspacePayURLImpl
implements WorkspacePayURL {
    private WorkspacePayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getWorkspacePayURL();
        }
        return new SantanderHomoURL().getWorkspacePayURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(WorkspacePayParams params) {
        WorkspacePayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationUrl(), new Object[0]);
        return url;
    }

    @Override
    public String getUpdateUrl(WorkspacePayParams params) {
        WorkspacePayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getUpdateUrl(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getDeleteUrl(WorkspacePayDeleteParams params) {
        WorkspacePayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getDeleteUrl(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getListUrl(WorkspacePayListParams params) {
        WorkspacePayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListUrl(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getListAllUrl(WorkspacePayListAllParams params) {
        WorkspacePayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListAllUrl(), new Object[0]);
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).build();
        return url;
    }
}

