/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.statements;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsInterface;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.SantanderStatementImpl;
import com.touchcomp.basementorbanks.services.impl.statements.model.StatementParams;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;

public class BankStatements {
    public ProcessResult<StatementParams, Statements> getStatements(StatementParams params) throws BankException, BankNotSupportedException {
        StatementsInterface found = this.get(params.getToken().getBankCredentials());
        return found.getStatements(params);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        StatementsInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private StatementsInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderStatementImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

