/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.statements.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsConverter;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.constants.EnumCreditDebitType;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.util.Date;
import java.util.LinkedList;
import org.codehaus.jackson.JsonNode;

public class SantanderStatementConvImpl
extends BankJsonConverter
implements StatementsConverter {
    @Override
    public Statements textToStatements(String json, EnvironmentType environmentType) throws BankException {
        Statements ret = new Statements();
        JsonNode jsonNode = this.getRoot(json);
        JsonNode content = jsonNode.findValue("_content");
        LinkedList<Statements.Statement> aux = new LinkedList<Statements.Statement>();
        for (JsonNode statementNode : content) {
            String creditDebitType = this.asText(statementNode, "creditDebitType");
            String transactionName = this.asText(statementNode, "transactionName");
            String historicComplement = this.asText(statementNode, "historicComplement");
            Double amount = this.asDouble(statementNode, "amount");
            Date transactionDate = this.asDate(statementNode, "transactionDate", UtilDate.Mask.TRACE_FORMATTER);
            aux.add(new Statements.Statement(EnumCreditDebitType.getBy(creditDebitType), transactionName, historicComplement, amount, transactionDate));
        }
        ret.setStatements(aux);
        return ret;
    }
}

