/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.statements.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsConverter;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsInterface;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsValid;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.SantanderStatementConvImpl;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.SantanderStatementsURLConvImpl;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.SantanderValidStatementsImpl;
import com.touchcomp.basementorbanks.services.impl.statements.model.StatementParams;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;

public class SantanderStatementImpl
extends SantanderBaseConnection
implements StatementsInterface {
    private final StatementsConverter converter = new SantanderStatementConvImpl();
    private final SantanderStatementsURLConvImpl urlConverter = new SantanderStatementsURLConvImpl();
    private final StatementsValid validator = new SantanderValidStatementsImpl();

    @Override
    public ProcessResult<StatementParams, Statements> getStatements(StatementParams params) throws BankException {
        Statements ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getStatementsUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToStatements(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<StatementParams, Object>(params, ret, res);
        }
        return new ProcessResult<StatementParams, Statements>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String url = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, url);
    }
}

