/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.statements.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.statements.StatementsURLConverter;
import com.touchcomp.basementorbanks.services.impl.statements.model.StatementParams;
import com.touchcomp.basementorbanks.url.StatementsURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderStatementsURLConvImpl
implements StatementsURLConverter {
    private StatementsURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getStatementsURL();
        }
        return new SantanderHomoURL().getStatementsURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getStatementsUrl(StatementParams params) {
        String bankDoc = params.getDocumentBank();
        if (!UtilMethods.isStrWithData(bankDoc)) {
            bankDoc = params.getBankNumber().getCode();
        }
        String url = UtilMethods.formatMessage(this.getUrl(params.getToken().getBankCredentials().getEnvironmentType()).getStatementsUrl(), bankDoc, params.getBranchCode(), params.getAccountNumber());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("accountId", Optional.ofNullable(params.getAccountId())).queryParamIfPresent("initialDate", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("finalDate", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDate(), UtilDate.Mask.TRACE_FORMATTER))).build();
        return url;
    }
}

