/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.statements.ofx;

import com.touchcomp.basementorbanks.constants.CharsetType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.constants.EnumCreditDebitType;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.ResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.banking.BankStatementResponseTransaction;
import com.webcohesion.ofx4j.domain.data.banking.BankingResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.common.Transaction;
import com.webcohesion.ofx4j.domain.data.signon.SignonResponse;
import com.webcohesion.ofx4j.io.AggregateUnmarshaller;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BankOFXFileReader {
    public Statements lerArquivoOFX(InputStream inputStreamOFX, Integer numeroDiasDifConc, CharsetType charset) throws BankException {
        FileInputStream fis = null;
        try {
            AggregateUnmarshaller a = new AggregateUnmarshaller(ResponseEnvelope.class);
            fis = new FileInputStream(this.getTempFile(inputStreamOFX, charset));
            ResponseEnvelope re = (ResponseEnvelope)a.unmarshal((InputStream)fis);
            Statements statements = this.getStatements(re, numeroDiasDifConc);
            return statements;
        }
        catch (IOException ex) {
            Logger.getLogger(BankOFXFileReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException("E.BANK.000013", ex);
        }
        catch (OFXParseException ex) {
            Logger.getLogger(BankOFXFileReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException("E.BANK.000013", ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(BankOFXFileReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void debug(String msg) {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg);
    }

    private File getTempFile(InputStream inputStreamOFX, CharsetType charset) throws BankException {
        try {
            String texto = new String(inputStreamOFX.readAllBytes(), charset.getValue());
            texto = UtilMethods.clearInvalidUTF8Char(texto);
            texto = texto.replace("&", "");
            File temp = File.createTempFile("temp", ".ofx");
            FileWriter fileWriter = new FileWriter(temp, true);
            PrintWriter p = new PrintWriter(fileWriter);
            p.append(texto.trim());
            p.flush();
            p.close();
            return temp;
        }
        catch (IOException ex) {
            Logger.getLogger(BankOFXFileReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException("E.BANK.000013", ex);
        }
    }

    private Statements getStatements(ResponseEnvelope re, Integer numeroDiasDifConc) {
        Statements sta = new Statements();
        ArrayList<Statements.Statement> itens = new ArrayList<Statements.Statement>();
        SignonResponse sr = re.getSignonResponse();
        MessageSetType type = MessageSetType.banking;
        ResponseMessageSet message = re.getMessageSet(type);
        if (message == null) {
            return sta;
        }
        List bank = ((BankingResponseMessageSet)message).getStatementResponses();
        for (BankStatementResponseTransaction b : bank) {
            this.debug("cc: " + b.getMessage().getAccount().getAccountNumber());
            this.debug("ag: " + b.getMessage().getAccount().getBranchId());
            this.debug("balan\u00e7o final: " + b.getMessage().getLedgerBalance().getAmount());
            this.debug("dataDoArquivo: " + String.valueOf(b.getMessage().getLedgerBalance().getAsOfDate()));
            List list = b.getMessage().getTransactionList().getTransactions();
            this.debug("TRANSACOES\n");
            for (Transaction transaction : list) {
                this.debug("tipo: " + transaction.getTransactionType().name());
                this.debug("id: " + transaction.getId());
                this.debug("data: " + String.valueOf(transaction.getDatePosted()));
                this.debug("valor: " + transaction.getAmount());
                this.debug("descricao: " + transaction.getMemo());
                this.debug("");
                Statements.Statement i = new Statements.Statement();
                Double valor = transaction.getAmount();
                if (valor != null && valor >= 0.0) {
                    i.setCreditDebitType(EnumCreditDebitType.CREDITO);
                    i.setAmount(valor);
                } else if (valor != null && valor < 0.0) {
                    i.setCreditDebitType(EnumCreditDebitType.DEBITO);
                    i.setAmount(valor * -1.0);
                }
                i.setTransactionName(transaction.getMemo());
                i.setTransactionDate(UtilDate.dataSemHora(UtilDate.nextDateByDays(transaction.getDatePosted(), numeroDiasDifConc)));
                itens.add(i);
            }
        }
        sta.setStatements(itens);
        return sta;
    }
}

