/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.util;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.url.BankURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class BankKeystoreUtil {
    private final int DEFAULT_SSL_PORT = 443;
    private static final String PROTOCOL = "TLSv1.2";

    public File geraCadeiaCertificadosFile(File keystoreFile, String senha) throws Exception {
        return this.geraCadeiaCertificadosFile(EnvironmentType.PRODUCAO, keystoreFile, senha);
    }

    public File geraCadeiaCertificadosFile(EnvironmentType type, File keystoreFile, String senha) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fis = new FileInputStream(keystoreFile);){
            keyStore.load(fis, senha.toCharArray());
        }
        this.get(keyStore, this.getHosts(type));
        File tempFile = File.createTempFile("keystore", ".jks");
        try (FileOutputStream fout = new FileOutputStream(tempFile);){
            keyStore.store(fout, senha.toCharArray());
        }
        return tempFile;
    }

    public File geraCadeiaCertificadosFile(EnvironmentType type, String senha) throws Exception {
        File tempFile = File.createTempFile("keystore", ".jks");
        try (FileOutputStream fout = new FileOutputStream(tempFile);){
            fout.write(this.geraCadeiaCertificados(this.getHosts(type), senha));
            fout.flush();
        }
        return tempFile;
    }

    public String getHostFromUrl(String url) throws URISyntaxException {
        return new URI(url).getHost();
    }

    private byte[] geraCadeiaCertificados(List<String> hosts, String senha) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, senha.toCharArray());
        this.get(keyStore, hosts);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            keyStore.store(out, senha.toCharArray());
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public StringBuilder listCertificates(File arquivoJKS, String pass) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (arquivoJKS == null) {
            return builder;
        }
        try (FileInputStream is = new FileInputStream(arquivoJKS);){
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, pass.toCharArray());
            Enumeration<String> enumeration = keystore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                builder.append(alias).append(": ");
                Certificate certificate = keystore.getCertificate(alias);
                if (certificate instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)certificate;
                    builder.append(" Validade: ").append(UtilDate.dateToStr(cert.getNotAfter())).append("\n");
                    builder.append(" Det: ").append(cert.getSubjectX500Principal().getName());
                } else {
                    builder.append(certificate.toString());
                }
                builder.append("\n");
            }
        }
        return builder;
    }

    private void get(KeyStore keyStore, List<String> hosts) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateEncodingException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(defaultTrustManager);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(null, new TrustManager[]{savingTrustManager}, null);
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        for (String host : hosts) {
            try (SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(host, 443);){
                sslSocket.setSoTimeout(10000);
                sslSocket.startHandshake();
            }
            if (savingTrustManager.chain == null) continue;
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < savingTrustManager.chain.length; ++i) {
                X509Certificate certificate = savingTrustManager.chain[i];
                sha1.update(certificate.getEncoded());
                md5.update(certificate.getEncoded());
                String alias = String.format("%s.%s", host, i + 1);
                keyStore.setCertificateEntry(alias, certificate);
            }
        }
    }

    private List<String> getHosts(EnvironmentType type) {
        LinkedList<String> urls = new LinkedList<String>();
        BankURLInterface santander = type.equals((Object)EnvironmentType.HOMOLOGACAO) ? new SantanderHomoURL() : new SantanderProdURL();
        urls.addAll(santander.getHosts());
        return urls;
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
        }
    }
}

