/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class UriComponentsBuilder {
    private String url;
    private final Map<String, Object> queryParams = new HashMap<String, Object>();

    public UriComponentsBuilder(String url) {
        this.url = url;
    }

    public static UriComponentsBuilder from(String url) {
        return new UriComponentsBuilder(url);
    }

    public UriComponentsBuilder queryParamIfPresent(String name, Optional<?> value) {
        value.ifPresent(v -> this.queryParam(name, String.valueOf(v)));
        return this;
    }

    private UriComponentsBuilder queryParam(String name, String v) {
        this.queryParams.put(name, v);
        return this;
    }

    public String build() {
        if (this.queryParams.isEmpty()) {
            return this.url;
        }
        if (!this.url.endsWith("?")) {
            this.url = this.url + "?";
        }
        StringBuilder sb = new StringBuilder(this.url);
        Set<String> keys = this.queryParams.keySet();
        int counter = 0;
        int max = this.queryParams.size();
        for (String key : keys) {
            sb.append(key).append("=").append(this.queryParams.get(key));
            if (counter < max - 1) {
                sb.append("&");
            }
            ++counter;
        }
        return sb.toString();
    }
}

