/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.util;

import com.touchcomp.basementorbanks.exceptions.BankRuntimeException;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Date;

public class UtilDate {
    public static Date nextDateByDays(Date base, int add) {
        if (base == null) {
            return null;
        }
        Calendar today = Calendar.getInstance();
        today.setTime(base);
        today.add(6, add);
        return today.getTime();
    }

    public static Date nextDateBySeconds(Date base, int add) {
        if (base == null) {
            return null;
        }
        Calendar today = Calendar.getInstance();
        today.setTime(base);
        today.add(13, add);
        return today.getTime();
    }

    public static String dateToStr(LocalDate localDate, Mask mask) {
        if (localDate == null || mask == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(mask.getDateMask());
        return localDate.format(formatter);
    }

    public static String dateToStr(LocalDateTime localDate, Mask mask) {
        if (localDate == null || mask == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(mask.getDateMask());
        return localDate.format(formatter);
    }

    public static String dateToStr(Date date, Mask mask) {
        if (date == null || mask == null) {
            return null;
        }
        SimpleDateFormat d = new SimpleDateFormat(mask.getDateMask());
        return d.format(date);
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat d = new SimpleDateFormat(Mask.BAR_FORMATTER.getDateMask());
        return d.format(date);
    }

    public static Date strToDate(String strDate, Mask mask) {
        if (!UtilMethods.isStrWithData(strDate) || mask == null) {
            return null;
        }
        try {
            SimpleDateFormat d = new SimpleDateFormat(mask.getDateMask());
            return d.parse(strDate);
        }
        catch (ParseException ex) {
            throw new BankRuntimeException("E.BANK.000009", (Throwable)ex, strDate, mask.getDateMask());
        }
    }

    public static Date dataSemHora(Date nextDateByDays) {
        return UtilDate.strToDate(UtilDate.dateToStr(nextDateByDays), Mask.BAR_FORMATTER);
    }

    public static LocalDate strToLocalDate(String dateStr, Mask mask) {
        if (!UtilMethods.isStrWithData(dateStr) || mask == null) {
            return null;
        }
        if (dateStr.length() > 24) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateStr);
            LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
            return localDateTime.toLocalDate();
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern(mask.getDateMask())).toFormatter();
        return LocalDate.parse(dateStr, formatter);
    }

    public static LocalDateTime strToLocalDateTime(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        if (dateStr.length() > 24) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateStr);
            LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
            return localDateTime;
        }
        Instant instant = Instant.parse(dateStr);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDate nextLocalDateByDays(LocalDate localDate, int days) {
        localDate = localDate.plusDays(days);
        return localDate;
    }

    public static LocalDateTime previousLocalDateTimeByDays(LocalDateTime localDate, int days) {
        localDate = localDate.minusDays(days);
        return localDate;
    }

    public static enum Mask {
        TRACE_FORMATTER("yyyy-MM-dd"),
        HOUR_FORMATTER("hh:MM:ss"),
        TRACE_PERIOD_FORMATTER("yyyy-MM"),
        BAR_FORMATTER("dd/MM/yyyy");

        private final String dateMask;

        private Mask(String mask) {
            this.dateMask = mask;
        }

        public String getDateMask() {
            return this.dateMask;
        }
    }
}

