/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.util;

import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.util.UtilFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class UtilDownload {
    private UtilDownload() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static File download(String fileURL) throws BankException {
        File f = UtilFile.createTempFile("arquivo", ".pdf");
        try (BufferedInputStream in = new BufferedInputStream(new URI(fileURL).toURL().openStream());){
            File file;
            try (FileOutputStream fileOutputStream = new FileOutputStream(f);){
                int bytesRead;
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
                file = f;
            }
            return file;
        }
        catch (IOException | URISyntaxException e) {
            throw new BankException(e);
        }
    }
}

