/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Collection;

public class UtilMethods {
    public static String onlyNumbers(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] dados = str.toCharArray();
        for (int i = 0; i < dados.length; ++i) {
            if (!Character.isDigit(dados[i])) continue;
            sb.append(dados[i]);
        }
        return sb.toString();
    }

    public static boolean isStrWithData(String str) {
        return str != null && str.length() > 0;
    }

    public static String formatMessage(String mask, Object ... values) {
        Object[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = values[i] == null ? "" : String.valueOf(values[i]);
        }
        return MessageFormat.format(mask, strings);
    }

    public static boolean isWithData(Object bankNumber) {
        return bankNumber != null;
    }

    public static boolean isWithData(Collection data) {
        return data != null && data.size() > 0;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String clearInvalidUTF8Char(String input) {
        if (input == null) {
            return "";
        }
        input = UtilMethods.changeSpecialChars(input);
        StringBuilder ret = new StringBuilder();
        for (char c : input.toCharArray()) {
            String str = String.valueOf(c);
            if (UtilMethods.isUTF8MisInterpreted(str)) {
                ret.append(str);
                continue;
            }
            System.out.println("Invalid UTF-8 Char: " + str);
        }
        return ret.toString();
    }

    public static String changeSpecialChars(String toFilter) {
        if (toFilter == null) {
            return "";
        }
        char[] ch = toFilter.toCharArray();
        Object r = "";
        char last = ' ';
        for (int i = 0; i < ch.length; ++i) {
            char current = ch[i];
            if (last != ' ' || current != ' ') {
                r = current == '\u00a7' ? (String)r : (current == '\u00b0' ? (String)r : (current == '!' ? (String)r : (current == '`' ? (String)r : (current == '`' ? (String)r : (current == '$' ? (String)r : (current == '#' ? (String)r : (current == '\u00e1' ? (String)r + "a" : (current == '\u00e2' ? (String)r + "a" : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e3' ? (String)r + "a" : (current == '\u00e7' ? (String)r + "c" : (current == '&' ? (String)r : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e9' ? (String)r + "e" : (current == '\u00ea' ? (String)r + "e" : (current == '\u00ed' ? (String)r + "i" : (current == '\u00f3' ? (String)r + "o" : (current == '\u00f4' ? (String)r + "o" : (current == '\u00f5' ? (String)r + "o" : (current == '\u00fa' ? (String)r + "u" : (current == '\u00e7' ? (String)r + "c" : (current == '\u00fc' ? (String)r + "u" : (current == '\u00c1' ? (String)r + "A" : (current == '\u00c2' ? (String)r + "A" : (current == '\u00c0' ? (String)r + "A" : (current == '\u00c3' ? (String)r + "A" : (current == '\u00c7' ? (String)r + "C" : (current == '\u00c9' ? (String)r + "E" : (current == '\u00ca' ? (String)r + "E;" : (current == '\u00cd' ? (String)r + "I" : (current == '\u00d3' ? (String)r + "O" : (current == '\u00d4' ? (String)r + "O" : (current == '\u00d5' ? (String)r + "O" : (current == '\u00da' ? (String)r + "U" : (current == '\u00dc' ? (String)r + "U" : (current == '\u00c7' ? (String)r + "C" : (current == '\n' ? (String)r : (current == '\u00ba' ? (String)r : (current == '\u00b0' ? (String)r : (current == '\u00a7' ? (String)r : (current == '\u00a9' ? (String)r : (current == '\u00aa' ? (String)r : (current == '\r' ? (String)r : (current == '\t' ? (String)r : (current == '\u0003' ? (String)r : (current == '\u00a3' ? (String)r : (current == '\u0192' ? (String)r : (current == '\u2030' ? (String)r : (current == '\ufffd' ? (String)r : (String)r + current)))))))))))))))))))))))))))))))))))))))))))))))));
            }
            last = current;
        }
        while (((String)r).startsWith(" ")) {
            r = ((String)r).substring(1);
        }
        while (((String)r).endsWith(" ")) {
            r = ((String)r).substring(0, ((String)r).length() - 1);
        }
        return r;
    }

    public static boolean isUTF8MisInterpreted(String input) {
        return UtilMethods.isUTF8MisInterpreted(input, "Windows-1252");
    }

    public static boolean isUTF8MisInterpreted(String input, String encoding) {
        ByteBuffer tmp;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        try {
            tmp = encoder.encode(CharBuffer.wrap(input));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        try {
            decoder.decode(tmp);
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static byte[] getBytesFromFile(InputStream in) throws IOException {
        return in.readAllBytes();
    }

    public static String getStringFromFile(InputStream in) throws IOException {
        return new String(UtilMethods.getBytesFromFile(in));
    }
}

