/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbinary;

import com.touchcomp.basementorbinary.model.ArqCheckListAssinaturas;
import com.touchcomp.basementorbinary.model.ArqEvtComprovanteEntrega;
import com.touchcomp.basementorbinary.model.ArqFotoColaborador;
import com.touchcomp.basementorbinary.model.ArqFotosCheckinoutVisita;
import com.touchcomp.basementorbinary.model.ArqFotosItemCheckList;
import com.touchcomp.basementorbinary.model.ArqImagemBI;
import com.touchcomp.basementorbinary.model.ArqImagemPrincipalBI;
import com.touchcomp.basementorbinary.model.ArqRascunhoRecurso;
import com.touchcomp.basementorbinary.model.ArquivamentoDadosFile;
import com.touchcomp.basementorbinary.model.InfAdicionaisImagemPes;
import com.touchcomp.basementorbinary.model.InfAdicionaisImagemProd;
import com.touchcomp.basementorbinary.model.InfAdicionaisProduto;
import com.touchcomp.basementorbinary.model.PreferenciasTabela;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class ConfHibernateBinary {
    @Autowired
    private Environment environment;
    private static String urlConexaoLocal;
    private static String dbUserLocal;
    private static String dbPassLocal;
    private static String dbDriverLocal;
    private static String showSQLLocal;

    @Bean(name={"sessionFactoryBinary"})
    public LocalSessionFactoryBean sessionFactoryBinary() throws ExceptionReflection {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        sessionFactory.setDataSource(this.dataSourceBinary());
        sessionFactory.setAnnotatedClasses((Class[])this.getAllClasses());
        sessionFactory.setHibernateProperties(this.getHibernateProps());
        return sessionFactory;
    }

    private Class<?>[] getAllClasses() throws ExceptionReflection {
        LinkedList<Class> all = new LinkedList<Class>();
        all.add(ArqCheckListAssinaturas.class);
        all.add(ArqFotoColaborador.class);
        all.add(ArqFotosCheckinoutVisita.class);
        all.add(ArqFotosItemCheckList.class);
        all.add(ArqImagemBI.class);
        all.add(ArqRascunhoRecurso.class);
        all.add(ArquivamentoDadosFile.class);
        all.add(PreferenciasTabela.class);
        all.add(ArqImagemBI.class);
        all.add(ArqImagemPrincipalBI.class);
        all.add(InfAdicionaisProduto.class);
        all.add(InfAdicionaisImagemProd.class);
        all.add(InfAdicionaisImagemPes.class);
        all.add(ArqEvtComprovanteEntrega.class);
        return all.toArray(new Class[0]);
    }

    private Properties getHibernateProps() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.environment.getRequiredProperty("hibernate.dialect"));
        if (TMethods.isStrWithData((String)showSQLLocal)) {
            properties.put("hibernate.show_sql", showSQLLocal);
        }
        properties.put("hibernate.hbm2ddl.auto", this.environment.getRequiredProperty("hibernate.hbm2ddl.auto"));
        properties.put("hibernate.enable_lazy_load_no_trans", "true");
        properties.put("hibernate.id.new_generator_mappings", "false");
        properties.put("hibernate.event.merge.entity_copy_observer", "allow");
        return properties;
    }

    @Bean
    public DataSource dataSourceBinary() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(dbDriverLocal);
        dataSource.setUrl(urlConexaoLocal);
        dataSource.setUsername(dbUserLocal);
        dataSource.setPassword(dbPassLocal);
        return dataSource;
    }

    @Bean(name={"transactionManagerBinary"})
    @Autowired
    public HibernateTransactionManager transactionManager(@Qualifier(value="sessionFactoryBinary") SessionFactory sessionFactoryLogAcoes) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactoryLogAcoes);
        return txManager;
    }

    public static void setConfig(String dbDriver, String urlConexao, String dbUser, String dbPass, String showSQL) {
        urlConexaoLocal = urlConexao;
        dbUserLocal = dbUser;
        dbPassLocal = dbPass;
        dbDriverLocal = dbDriver;
        showSQLLocal = showSQL;
    }
}

