/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbinary.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementorbinary.dao.DaoBinaryGenericEntityImpl;
import com.touchcomp.basementorbinary.model.ArqRascunhoRecurso;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBinaryArqRascunhoRecurso
extends DaoBinaryGenericEntityImpl<ArqRascunhoRecurso, Long> {
    public List<ArqRascunhoRecurso> getRascunhos(String controllerNodo, Long usuario, Long empresa, Short filtrarPorAutomaticos) {
        Criteria c = this.criteria();
        c.add(this.eq("controllerNodo", controllerNodo));
        if (usuario != null) {
            c.add(this.eq("usuarioIdentificador", usuario));
        }
        if (empresa != null) {
            c.add(this.eq("empresaIdentificador", empresa));
        }
        if (TMethods.isAffirmative((Number)filtrarPorAutomaticos)) {
            c.add(this.eq("geradoAutomatico", filtrarPorAutomaticos));
        }
        return c.list();
    }

    public ArqRascunhoRecurso getRascunhoAutomatico(String controllerNodo, Long usuario, Long empresa) {
        return (ArqRascunhoRecurso)this.toUnique(this.restrictions(this.criteria(), this.eq("controllerNodo", controllerNodo), this.eq("geradoAutomatico", EnumConstantsMentorSimNao.SIM.getValue())));
    }

    public void deletarRascunhos(Integer prazo) {
        Query query = this.query("delete from ArqRascunhoRecurso a where a.dataCadastro < :data");
        query.setParameter("data", (Object)ToolDate.previousDays((Date)new Date(), (int)prazo));
        query.executeUpdate();
    }
}

