/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbinary.service.impl.arq_rascunho_recurso;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementorbinary.dao.DaoBinaryGenericEntity;
import com.touchcomp.basementorbinary.dao.impl.DaoBinaryArqRascunhoRecurso;
import com.touchcomp.basementorbinary.model.ArqRascunhoRecurso;
import com.touchcomp.basementorbinary.service.ServiceBinaryGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBinaryArqRascunhoRecurso
extends ServiceBinaryGenericEntityImpl<ArqRascunhoRecurso, Long> {
    @Autowired
    public ServiceBinaryArqRascunhoRecurso(DaoBinaryGenericEntity<ArqRascunhoRecurso, Long> dao) {
        super(dao);
    }

    public List<ArqRascunhoRecurso> getRascunhos(String controllerNodo, Long usuario, Long empresa) {
        return ((DaoBinaryArqRascunhoRecurso)this.getDao()).getRascunhos(controllerNodo, usuario, empresa, EnumConstantsMentorSimNao.NAO.getValue());
    }

    public List<ArqRascunhoRecurso> getRascunhosSalvosAutomatico(String controllerNodo, Long user, Long empresa) {
        return ((DaoBinaryArqRascunhoRecurso)this.getDao()).getRascunhos(controllerNodo, user, empresa, EnumConstantsMentorSimNao.SIM.getValue());
    }

    public ArqRascunhoRecurso save(String controllerNodo, Long user, Long empresa, String descricao, Short geradoAutomatico, String dto) {
        ArqRascunhoRecurso vo = new ArqRascunhoRecurso();
        if (TMethods.isAffirmative((Number)geradoAutomatico) && (vo = ((DaoBinaryArqRascunhoRecurso)this.getDao()).getRascunhoAutomatico(controllerNodo, user, empresa)) == null) {
            vo = new ArqRascunhoRecurso();
        }
        vo.setConteudo(dto);
        vo.setDataCadastro(new Date());
        vo.setControllerNodo(controllerNodo);
        vo.setUsuarioIdentificador(user);
        vo.setEmpresaIdentificador(empresa);
        vo.setDescricao(descricao);
        vo.setGeradoAutomatico(geradoAutomatico);
        vo = this.getDao().saveOrUpdate(vo);
        return vo;
    }

    public void deletarRascunhos(Integer prazo) {
        if (prazo == null || prazo <= 0) {
            return;
        }
        ((DaoBinaryArqRascunhoRecurso)this.getDao()).deletarRascunhos(prazo);
    }
}

