/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbinary.service.impl.arqimagembi;

import com.touchcomp.basementorbinary.dao.impl.DaoBinaryArqImagemBI;
import com.touchcomp.basementorbinary.model.ArqImagemBI;
import com.touchcomp.basementorbinary.service.ServiceBinaryGenericEntityImpl;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.image.ToolImage;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBinaryArqImagemBIImpl
extends ServiceBinaryGenericEntityImpl<ArqImagemBI, Long> {
    @Autowired
    public ServiceBinaryArqImagemBIImpl(DaoBinaryArqImagemBI dao) {
        super(dao);
    }

    public ArqImagemBI getArqImagemBI(Long identificador, Short tipo, Integer indice) {
        return ((DaoBinaryArqImagemBI)this.getDao()).getArqImagens(identificador, tipo, indice);
    }

    public List<ArqImagemBI> getImagens(Long idInfAdicional, Short tipo) {
        return ((DaoBinaryArqImagemBI)this.getDao()).getImagens(idInfAdicional, tipo);
    }

    public String processImage(byte[] img, Dimension dimension) throws ExceptionIO {
        if (TMethods.isNull((Object)img).booleanValue()) {
            return null;
        }
        ToolImage.ImageFormat format = ToolImage.getImageFormat((byte[])img);
        if (!ToolMethods.isEquals((Object)format, (Object)ToolImage.ImageFormat.PNG)) {
            img = ToolImage.convertImage((byte[])img, (ToolImage.ImageFormat)ToolImage.ImageFormat.PNG);
        }
        File temp = ToolFile.createTempFile((String)"imagem.png");
        ToolFile.writeBytesOnFile((File)temp, (byte[])img);
        temp = ToolImage.resizeImageKeepAspectRatioIfGreater((File)temp, (Dimension)dimension);
        img = ToolFile.getBytesFromFile((File)temp);
        return ToolBase64.encodeBase64((byte[])img);
    }

    public void deleteImagemBI(Long identificador) {
        ArqImagemBI vo = (ArqImagemBI)this.get(identificador);
        if (vo != null) {
            this.delete(identificador);
        }
    }
}

