/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.components;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EsocBasesAquiProdRural;
import com.touchcomp.basementor.model.vo.EsocBasesRemun5011;
import com.touchcomp.basementor.model.vo.EsocEstabelecimentos5011;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocItemValoresFgtsColaborador;
import com.touchcomp.basementor.model.vo.EsocItemValoresInss;
import com.touchcomp.basementor.model.vo.EsocItemValoresIrrf;
import com.touchcomp.basementor.model.vo.EsocLotacaoTributaria5011;
import com.touchcomp.basementor.model.vo.EsocLoteEventos;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.EsocValoresContSociaisDevidas;
import com.touchcomp.basementor.model.vo.EsocValoresFgtsColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresInssColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresIrrfColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresOutrasEntidades;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.esocial.ConstantsNamespace;
import com.touchcomp.basementorclientwebservices.esocial.DocFactoryEventosEsocial;
import com.touchcomp.basementorclientwebservices.esocial.SignatureXmlEsocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.EsocialEvento;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorclientwebservices.esocial.webservices.consulta.ServicoConsultarLoteEventosStub;
import com.touchcomp.basementorclientwebservices.esocial.webservices.consulta.model.ConsultaLoteEventos;
import com.touchcomp.basementorclientwebservices.esocial.webservices.consulta.model.EsocialConsulta;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.ServicoEnviarLoteEventosStub;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.EnvioLoteEventos;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.EsocialEnvio;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.Evento;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.Eventos;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.webservices.envio.model.TTransmissor;
import com.touchcomp.basementorclientwebservices.esocial.webservicesproducaorestrita.consulta.RestritoServicoConsultarLoteEventosStub;
import com.touchcomp.basementorclientwebservices.esocial.webservicesproducaorestrita.envio.RestritoServicoEnviarLoteEventosStub;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.axis.ExceptionAxis;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionInvalidXML;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.hashmd5.ToolHashMD5;
import com.touchcomp.basementortools.tools.jaxb.ToolJaxb;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLEventoEsocial;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoEsocial;
import java.io.File;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.stereotype.Component;

@Component
public class DocEsocialBase {
    public void validarXMLLoteEventos(EsocLoteEventos loteEventos, OpcoesESocial opcoesEsocial) throws ExceptionEsocial, ExceptionIO, ExceptionJDom, ExceptionInvalidXML, ExceptionJaxb {
        for (EsocEvento evento : loteEventos.getEventos()) {
            EsocialEvento esocial = DocFactoryEventosEsocial.getEvento(evento, opcoesEsocial);
            String xml = ToolJaxb.toXMl((Object)esocial, (boolean)true);
            System.out.println(xml);
        }
    }

    public String salvarXml(EsocEvento evento, OpcoesESocial opcoesEsocial) throws ExceptionEsocial, ExceptionIO, ExceptionJDom, ExceptionInvalidXML, ExceptionJaxb {
        EsocialEvento esocial = DocFactoryEventosEsocial.getEvento(evento, opcoesEsocial);
        String xml = ToolJaxb.toXMl((Object)esocial, (boolean)true);
        return xml;
    }

    public String gerarHashXMLEvento(EsocPreEvento preEvento, OpcoesESocial opcoeEsocial) throws ExceptionEsocial, ExceptionJaxb {
        Evento evt = this.buildEvento(preEvento, opcoeEsocial);
        String xml = ToolJaxb.toXMl((Object)evt);
        return ToolHashMD5.gerarHashXMLEvento((String)xml);
    }

    public void enviarLoteEventos(EsocLoteEventos loteEventos, OpcoesESocial opcoes, ConfiguracaoCertificado conf) throws ExceptionEsocial, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        try {
            CertificadoConfClienteWebservice.configure(conf);
            EsocialEnvio enviarLoteEventos = this.buildEnviarLoteEventos(loteEventos, opcoes);
            String xml = this.montarXml(enviarLoteEventos);
            this.backupToFile(xml, this.getPathEnvioLotes(loteEventos));
            String result = loteEventos.getIdentificacaoAmbienteEsocial().getCodigo().equals("1") ? this.sendLoteEventos(xml) : this.sendLoteEventosRestrito(xml);
            this.backupToFile(xml, this.getPathRetornoEnvioLotes(loteEventos));
            this.setStatusLote(result, loteEventos);
        }
        catch (RemoteException ex) {
            throw new ExceptionAxis(ex);
        }
        catch (XMLStreamException ex) {
            throw new ExceptionAxis(ex);
        }
    }

    private File getPathEnvioLotes(EsocLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/esocial/envio/" + lote.getIdentificador() + "-env.xml");
    }

    private File getPathRetornoEnvioLotes(EsocLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/esocial/envio/" + lote.getIdentificador() + "-ret-env.xml");
    }

    private File getPathEnvioConsultaEnvioLotes(EsocLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/esocial/consulta/" + lote.getIdentificador() + "-cons.xml");
    }

    private File getPathRetornoEnvioConsultaLotes(EsocLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/esocial/consulta/" + lote.getIdentificador() + "-ret-cons.xml");
    }

    public void consultaLoteEventosEsocial(EsocLoteEventos loteEventos, OpcoesESocial opcoes, ConfiguracaoCertificado conf) throws ExceptionEsocial, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        try {
            CertificadoConfClienteWebservice.configure(conf);
            EsocialConsulta esocial = new EsocialConsulta();
            ConsultaLoteEventos consulta = new ConsultaLoteEventos();
            consulta.setProtocoloEnvio(loteEventos.getNumeroProtEnvio());
            esocial.setConsultaLoteEventos(consulta);
            String xml = ToolJaxb.toXMl((Object)esocial);
            this.backupToFile(xml, this.getPathEnvioConsultaEnvioLotes(loteEventos));
            String result = loteEventos.getIdentificacaoAmbienteEsocial().getCodigo().equals("1") ? this.sendConsultaLoteEventos(xml) : this.sendConsultaLoteEventosRestrito(xml);
            this.backupToFile(result, this.getPathRetornoEnvioConsultaLotes(loteEventos));
            this.setStatusConsultaLoteVersao(result, loteEventos);
        }
        catch (RemoteException ex) {
            throw new ExceptionAxis(ex);
        }
        catch (XMLStreamException ex) {
            throw new ExceptionAxis(ex);
        }
    }

    private static void testIgnoreCerts() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private String sendLoteEventos(String xml) throws AxisFault, RemoteException, XMLStreamException {
        try {
            DocEsocialBase.testIgnoreCerts();
            ServicoEnviarLoteEventosStub.EnviarLoteEventos consultaLote = new ServicoEnviarLoteEventosStub.EnviarLoteEventos();
            consultaLote.setLoteEventos(new ServicoEnviarLoteEventosStub.LoteEventos_type0());
            StringBuilder sb = new StringBuilder();
            sb.append(xml);
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            consultaLote.getLoteEventos().setExtraElement(el);
            ServicoEnviarLoteEventosStub serv = new ServicoEnviarLoteEventosStub();
            ServicoEnviarLoteEventosStub.EnviarLoteEventosResponse result = serv.enviarLoteEventos(consultaLote);
            return result.getEnviarLoteEventosResult().getExtraElement().toString();
        }
        catch (Exception ex) {
            Logger.getLogger(DocEsocialBase.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private String sendLoteEventosRestrito(String xml) throws AxisFault, RemoteException, XMLStreamException {
        try {
            RestritoServicoEnviarLoteEventosStub.EnviarLoteEventos consultaLote = new RestritoServicoEnviarLoteEventosStub.EnviarLoteEventos();
            consultaLote.setLoteEventos(new RestritoServicoEnviarLoteEventosStub.LoteEventos_type0());
            StringBuilder sb = new StringBuilder();
            sb.append(xml);
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            consultaLote.getLoteEventos().setExtraElement(el);
            RestritoServicoEnviarLoteEventosStub serv = new RestritoServicoEnviarLoteEventosStub();
            RestritoServicoEnviarLoteEventosStub.EnviarLoteEventosResponse result = serv.enviarLoteEventos(consultaLote);
            return result.getEnviarLoteEventosResult().getExtraElement().toString();
        }
        catch (RemoteException | XMLStreamException ex) {
            Logger.getLogger(DocEsocialBase.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private String sendConsultaLoteEventos(String xml) throws AxisFault, RemoteException, XMLStreamException {
        ServicoConsultarLoteEventosStub.ConsultarLoteEventos loteEventos = new ServicoConsultarLoteEventosStub.ConsultarLoteEventos();
        loteEventos.setConsulta(new ServicoConsultarLoteEventosStub.Consulta_type0());
        StringBuilder sb = new StringBuilder();
        sb.append(xml);
        OMElement el = AXIOMUtil.stringToOM((String)xml);
        loteEventos.getConsulta().setExtraElement(el);
        ServicoConsultarLoteEventosStub serv = new ServicoConsultarLoteEventosStub();
        ServicoConsultarLoteEventosStub.ConsultarLoteEventosResponse result = serv.consultarLoteEventos(loteEventos);
        return result.getConsultarLoteEventosResult().getExtraElement().toString();
    }

    private String sendConsultaLoteEventosRestrito(String xml) throws AxisFault, RemoteException, XMLStreamException {
        RestritoServicoConsultarLoteEventosStub.ConsultarLoteEventos loteEventos = new RestritoServicoConsultarLoteEventosStub.ConsultarLoteEventos();
        loteEventos.setConsulta(new RestritoServicoConsultarLoteEventosStub.Consulta_type0());
        StringBuilder sb = new StringBuilder();
        sb.append(xml);
        OMElement el = AXIOMUtil.stringToOM((String)xml);
        loteEventos.getConsulta().setExtraElement(el);
        RestritoServicoConsultarLoteEventosStub serv = new RestritoServicoConsultarLoteEventosStub();
        RestritoServicoConsultarLoteEventosStub.ConsultarLoteEventosResponse result = serv.consultarLoteEventos(loteEventos);
        return result.getConsultarLoteEventosResult().getExtraElement().toString();
    }

    private EsocialEnvio buildEnviarLoteEventos(EsocLoteEventos lote, OpcoesESocial opcoes) throws ExceptionEsocial {
        EnvioLoteEventos envio = new EnvioLoteEventos();
        envio.setGrupo(lote.getTipoEvento().getGrupoEventos());
        envio.setIdeEmpregador(this.getIdeEmpregador(opcoes));
        envio.setIdeTransmissor(this.getIdeTransmissor(opcoes));
        envio.setEventos(this.getEventos(lote, opcoes));
        EsocialEnvio esocial = new EsocialEnvio();
        esocial.setEnvioLoteEventos(envio);
        return esocial;
    }

    private TEmpregador getIdeEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador empregador = new TEmpregador();
        empregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        empregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return empregador;
    }

    private TTransmissor getIdeTransmissor(OpcoesESocial opcoes) throws ExceptionEsocial {
        TTransmissor transmissor = new TTransmissor();
        if (opcoes.getInformarCnpjProcuradora().equals((short)0)) {
            transmissor.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
            transmissor.setNrInsc(ToolEsocial.getNrInscricaoTransmissor(opcoes));
        } else {
            if (opcoes.getCnpjProcuradora().length() == 14) {
                transmissor.setTpInsc(Byte.parseByte("1"));
            } else {
                transmissor.setTpInsc(Byte.parseByte("2"));
            }
            transmissor.setNrInsc(ToolString.refina((String)opcoes.getCnpjProcuradora()));
        }
        return transmissor;
    }

    private Eventos getEventos(EsocLoteEventos lote, OpcoesESocial op) throws ExceptionEsocial {
        Eventos ev = new Eventos();
        LinkedList<Evento> eventos = new LinkedList<Evento>();
        for (EsocEvento evento : lote.getEventos()) {
            if (!ToolMethods.isEquals((Object)evento.getPreEvento().getDesativarEnvio(), (Object)EnumConstantsSimNao.NAO.getValue())) continue;
            eventos.add(this.buildEvento(evento, op));
        }
        ev.setEvento(eventos);
        return ev;
    }

    private Evento buildEvento(EsocEvento evt, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        Evento ev = new Evento();
        EsocialEvento ret = DocFactoryEventosEsocial.getEvento(evt, opcoesEsocial);
        ev.seteSocial(ret);
        ev.setId(ret.getId());
        return ev;
    }

    private Evento buildEvento(EsocPreEvento evt, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        Evento ev = new Evento();
        EsocialEvento ret = DocFactoryEventosEsocial.getEvento(evt, opcoesEsocial);
        ev.seteSocial(ret);
        ev.setId(ret.getId());
        return ev;
    }

    private void setStatusLote(String result, EsocLoteEventos loteEventos) throws ExceptionJDom, ExceptionIO {
        Element dadosRecepcaoLote;
        Element esocial = ToolJdom.getRootElement((String)result);
        Element retornoEnvioLoteEventos = esocial.getChild("retornoEnvioLoteEventos", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
        Element status = retornoEnvioLoteEventos.getChild("status", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
        loteEventos.setCodStatusEnvio(Long.valueOf(status.getChildText("cdResposta", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)));
        StringBuilder sb = new StringBuilder();
        sb.append(status.getChildText("descResposta", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
        Element ocorrencias = status.getChild("ocorrencias", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
        if (ToolMethods.isNotNull((Object)ocorrencias).booleanValue() && ToolMethods.isWithData((Collection)ocorrencias.getChildren())) {
            sb.append("Ocorrencias:").append("\n\n");
            for (Element ocorrencia : ocorrencias.getChildren("ocorrencia", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)) {
                sb.append("Codigo: ").append(ocorrencia.getChildText("codigo", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
                sb.append("Descricao: ").append(ocorrencia.getChildText("descricao", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
                sb.append("Tipo: ").append(ocorrencia.getChildText("tipo", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
                sb.append("Localizacao: ").append(ocorrencia.getChildText("localizacao", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
                sb.append("\n");
            }
        }
        if ((dadosRecepcaoLote = retornoEnvioLoteEventos.getChild("dadosRecepcaoLote", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)) != null) {
            loteEventos.setNumeroProtEnvio(dadosRecepcaoLote.getChildText("protocoloEnvio", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE));
            sb.append("Vers\u00c3\u00a3o Aplicativo: ").append(dadosRecepcaoLote.getChildText("versaoAplicativoRecepcao", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
            sb.append("Data Recepcao: ").append(dadosRecepcaoLote.getChildText("dhRecepcao", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)).append("\n");
        }
        loteEventos.setDescricaoEnvio(sb.toString());
    }

    private void setStatusConsultaLoteVersao(String result, EsocLoteEventos loteEventos) throws ExceptionJDom, ExceptionEsocial, ExceptionIO {
        Namespace namespace = ConstantsNamespace.NAMESPACE_RETORNO_PROCESSAMENTO;
        Namespace namespaceeEvt = Namespace.getNamespace((String)"http://www.esocial.gov.br/schema/evt/retornoEvento/v1_3_0");
        Namespace namespaceeEvtAux = Namespace.getNamespace((String)"http://www.esocial.gov.br/schema/evt/retornoEvento/v1_3_1");
        Element eSocial = ToolJdom.getRootElement((String)result);
        Element retornoProcessamentoLoteEventos = eSocial.getChild("retornoProcessamentoLoteEventos", namespace);
        Element retornoEventos = retornoProcessamentoLoteEventos.getChild("retornoEventos", namespace);
        if (retornoEventos == null || retornoEventos.getChildren("evento", namespace) == null) {
            Element status = retornoProcessamentoLoteEventos.getChild("status", namespace);
            for (EsocEvento esocEvento : loteEventos.getEventos()) {
                esocEvento.setStatus(Long.valueOf(status.getChildText("cdResposta", namespace)));
                esocEvento.setDescricaoStatus(status.getChildText("descResposta", namespace));
                StringBuilder sb = new StringBuilder();
                sb.append("Ocorrencia tipo ").append(esocEvento.getStatus().toString()).append("\n");
                sb.append(esocEvento.getDescricaoStatus());
                sb.append("\n\n");
                esocEvento.setDescricaoStatusDetalhada(sb.toString());
            }
            return;
        }
        List eventos = retornoEventos.getChildren("evento", namespace);
        for (Element evento : eventos) {
            this.salvarAprovacao(evento);
            String id = evento.getAttributeValue("Id");
            EsocEvento eventoLote = this.getEvento(loteEventos, id);
            if (eventoLote == null) continue;
            Element retornoEvento = evento.getChild("retornoEvento", namespace);
            if (retornoEvento.getChild("eSocial", namespaceeEvt) != null) {
                this.verificarStatusRetornoVersao(eventoLote, evento, namespaceeEvt, retornoEvento);
                continue;
            }
            this.verificarStatusRetornoVersao(eventoLote, evento, namespaceeEvtAux, retornoEvento);
        }
    }

    private void backupToFile(String xml, File pathEnvioLotes) throws ExceptionIO {
        ToolFile.writeStringInFile((String)pathEnvioLotes.getAbsolutePath(), (String)xml);
    }

    private EsocEvento getEvento(EsocLoteEventos loteEventos, String id) throws ExceptionEsocial {
        Optional<EsocEvento> evento = loteEventos.getEventos().stream().filter(evt -> evt.getIdTagEventoEsocial() != null && evt.getIdTagEventoEsocial().equals(id)).findFirst();
        if (evento.isPresent()) {
            return evento.get();
        }
        return null;
    }

    private String montarXml(EsocialEnvio enviarLoteEventos) throws ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO {
        StringBuilder loteEventos = new StringBuilder();
        loteEventos.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        loteEventos.append("<eSocial xmlns=\"http://www.esocial.gov.br/schema/lote/eventos/envio/v1_1_1\">");
        if (enviarLoteEventos.getEnvioLoteEventos().getGrupo().equals("1")) {
            loteEventos.append("<envioLoteEventos grupo=\"1\">");
        } else if (enviarLoteEventos.getEnvioLoteEventos().getGrupo().equals("2")) {
            loteEventos.append("<envioLoteEventos grupo=\"2\">");
        } else {
            loteEventos.append("<envioLoteEventos grupo=\"3\">");
        }
        loteEventos.append("<ideEmpregador>");
        loteEventos.append("<tpInsc>");
        loteEventos.append(enviarLoteEventos.getEnvioLoteEventos().getIdeEmpregador().getTpInsc());
        loteEventos.append("</tpInsc>");
        loteEventos.append("<nrInsc>");
        loteEventos.append(enviarLoteEventos.getEnvioLoteEventos().getIdeEmpregador().getNrInsc());
        loteEventos.append("</nrInsc>");
        loteEventos.append("</ideEmpregador>");
        loteEventos.append("<ideTransmissor>");
        loteEventos.append("<tpInsc>");
        loteEventos.append(enviarLoteEventos.getEnvioLoteEventos().getIdeTransmissor().getTpInsc());
        loteEventos.append("</tpInsc>");
        loteEventos.append("<nrInsc>");
        loteEventos.append(enviarLoteEventos.getEnvioLoteEventos().getIdeTransmissor().getNrInsc());
        loteEventos.append("</nrInsc>");
        loteEventos.append("</ideTransmissor>");
        loteEventos.append("<eventos>");
        for (Evento evt : enviarLoteEventos.getEnvioLoteEventos().getEventos().getEvento()) {
            StringBuilder eventoST = new StringBuilder();
            eventoST.append("<evento Id=\"").append(evt.getId()).append("\">");
            String temp = ToolJaxb.toXMl((Object)evt.geteSocial());
            temp = temp.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
            eventoST.append(SignatureXmlEsocial.assinarXMLEsocial(temp));
            eventoST.append("</evento>");
            this.salvarXml(eventoST.toString(), evt.getId());
            loteEventos.append((CharSequence)eventoST);
        }
        loteEventos.append("</eventos>");
        loteEventos.append("</envioLoteEventos>");
        loteEventos.append("</eSocial>");
        return loteEventos.toString();
    }

    private void salvarXml(String temp, String id) {
        ServiceXMLEventoEsocial serviceXmlEsocial = (ServiceXMLEventoEsocial)ConfApplicationContext.getBean(ServiceXMLEventoEsocial.class);
        XMLEventoEsocial xml = serviceXmlEsocial.getOrCreateByChave(id);
        xml.setConteudoXML(temp);
        serviceXmlEsocial.saveOrUpdate((Object)xml);
    }

    private void salvarAprovacao(Element evento) {
        ServiceXMLEventoEsocial serviceXmlEsocial = (ServiceXMLEventoEsocial)ConfApplicationContext.getBean(ServiceXMLEventoEsocial.class);
        XMLEventoEsocial xml = serviceXmlEsocial.getOrCreateByChave(evento.getAttributeValue("Id"));
        xml.setConteudoAprovacao(ToolJdom.toXml((Element)evento));
        serviceXmlEsocial.saveOrUpdate((Object)xml);
    }

    private void verificarRetornoImposto(EsocEvento eventoLote, Element evento) {
        if (this.getEventoComInssFgts(eventoLote)) {
            this.buscarRetornoS5001(eventoLote, evento);
        } else if (this.getEventoComIrrf(eventoLote)) {
            this.buscarRetornoS5002(eventoLote, evento);
        } else if (this.getEventoFechamentoPeriodo(eventoLote)) {
            this.buscarRetornoS5011(eventoLote, evento);
        }
    }

    private boolean getEventoComInssFgts(EsocEvento eventoLote) {
        Long idEvento = eventoLote.getEsocLoteEventos().getTipoEvento().getIdentificador();
        return idEvento.equals(ConstantsESocial.REGISTRO_2299) || idEvento.equals(ConstantsESocial.REGISTRO_1200);
    }

    private Date getPeriodoApuracao(EsocEvento eventoLote) {
        Long idEvento = eventoLote.getEsocLoteEventos().getTipoEvento().getIdentificador();
        if (idEvento.equals(ConstantsESocial.REGISTRO_2299)) {
            if (eventoLote.getPreEvento().getRecisao() != null) {
                return eventoLote.getPreEvento().getRecisao().getDataAfastamento();
            }
            return eventoLote.getPreEvento().getTransferenciaColaborador().getDataTransferencia();
        }
        if (eventoLote.getPreEvento().getRecisao() != null) {
            return eventoLote.getPreEvento().getRecisao().getRecisaoComplementarAc().getDataPagamento();
        }
        return eventoLote.getPreEvento().getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao();
    }

    private void buscarRetornoS5003(EsocEvento eventoLote, Element evento) {
        Namespace namespace = ConstantsNamespace.NAMESPACE_RETORNO_PROCESSAMENTO;
        Namespace namespaceeEvt = Namespace.getNamespace((String)"http://www.esocial.gov.br/schema/evt/evtBasesFGTS/v02_05_00");
        List listaRetorno = evento.getChildren("tot", namespace);
        for (Element element : listaRetorno) {
            EsocValoresFgtsColaborador valores;
            Element eSocialEvt = element.getChild("eSocial", namespaceeEvt);
            if (eSocialEvt == null) continue;
            if (eventoLote.getValoresFgts() == null) {
                valores = new EsocValoresFgtsColaborador();
            } else {
                valores = eventoLote.getValoresFgts();
                valores.setItens(new ArrayList());
            }
            Double baseFgts = 0.0;
            Double vlrFgts = 0.0;
            Element evtBasesFGTS = eSocialEvt.getChild("evtBasesFGTS", namespaceeEvt);
            Element infoFGTS = evtBasesFGTS.getChild("infoFGTS", namespaceeEvt);
            if (infoFGTS == null) {
                return;
            }
            List estabelecimentos = infoFGTS.getChildren("ideEstabLot", namespaceeEvt);
            for (Element est : estabelecimentos) {
                String codigoLotacao = est.getChildText("codLotacao", namespaceeEvt);
                List infoTrabFGTS = est.getChildren("infoTrabFGTS", namespaceeEvt);
                for (Element idEst : infoTrabFGTS) {
                    Element infoBaseFGTS = idEst.getChild("infoBaseFGTS", namespaceeEvt);
                    List basePerApur = infoBaseFGTS.getChildren("basePerApur", namespaceeEvt);
                    for (Element base : basePerApur) {
                        EsocItemValoresFgtsColaborador item = new EsocItemValoresFgtsColaborador();
                        String tpValor = base.getChildText("tpValor", namespaceeEvt);
                        String remFGTS = base.getChildText("remFGTS", namespaceeEvt);
                        item.setCodigoLotacao(codigoLotacao);
                        item.setTpValor(tpValor);
                        item.setRemuneracao(Double.valueOf(remFGTS));
                        baseFgts = baseFgts + ToolFormatter.arrredondarNumero((Double)item.getRemuneracao(), (int)2);
                        valores.getItens().add(item);
                        item.setEsocValores(valores);
                    }
                }
                Element infoDpsFGTS = infoFGTS.getChild("infoDpsFGTS", namespaceeEvt);
                if (infoDpsFGTS == null) {
                    return;
                }
                Element infoTrabDps = infoDpsFGTS.getChild("infoTrabDps", namespaceeEvt);
                List dpsPerApur = infoTrabDps.getChildren("dpsPerApur", namespaceeEvt);
                for (Element dp : dpsPerApur) {
                    EsocItemValoresFgtsColaborador item = new EsocItemValoresFgtsColaborador();
                    String tpDps = dp.getChildText("tpDps", namespaceeEvt);
                    String dpsFGTS = dp.getChildText("dpsFGTS", namespaceeEvt);
                    item.setCodigoLotacao(codigoLotacao);
                    item.setTpValor(tpDps);
                    item.setRemuneracao(Double.valueOf(dpsFGTS));
                    vlrFgts = vlrFgts + ToolFormatter.arrredondarNumero((Double)item.getRemuneracao(), (int)2);
                    item.setEsocValores(valores);
                    valores.getItens().add(item);
                }
            }
            valores.setBaseFgts(baseFgts);
            valores.setTotalDeposito(vlrFgts);
            valores.setPeriodoApuracao(this.getPeriodoApuracao(eventoLote));
            if (eventoLote.getValoresFgts() != null) continue;
            eventoLote.setValoresFgts(valores);
        }
    }

    private void buscarRetornoS5001(EsocEvento eventoLote, Element evento) {
        EsocValoresInssColaborador esocValores;
        Namespace namespace = ConstantsNamespace.NAMESPACE_RETORNO_PROCESSAMENTO;
        Namespace namespaceeEvt = ConstantsNamespace.NAMESPACE_EVENTO_5001;
        Element retornoEvento = evento.getChild("tot", namespace);
        Element eSocialEvt = retornoEvento.getChild("eSocial", namespaceeEvt);
        Element evtBasesTrab = eSocialEvt.getChild("evtBasesTrab", namespaceeEvt);
        Element infoCpCalc = evtBasesTrab.getChild("infoCpCalc", namespaceeEvt);
        Element infoCp = evtBasesTrab.getChild("infoCp", namespaceeEvt);
        if (eventoLote.getValoresInss() == null) {
            esocValores = new EsocValoresInssColaborador();
        } else {
            esocValores = eventoLote.getValoresInss();
            esocValores.setItens(new ArrayList());
        }
        if (infoCpCalc != null) {
            String codigoReceita = infoCpCalc.getChildText("tpCR", namespaceeEvt);
            String vrCpSeg = infoCpCalc.getChildText("vrCpSeg", namespaceeEvt);
            String vrDescSeg = infoCpCalc.getChildText("vrDescSeg", namespaceeEvt);
            esocValores.setCodigoReceita(codigoReceita);
            esocValores.setTotalDescontado(Double.valueOf(vrDescSeg));
            esocValores.setTotalInssEsocial(Double.valueOf(vrCpSeg));
            esocValores.setPeriodoApuracao(this.getPeriodoApuracao(eventoLote));
            Element ideEstabLot = infoCp.getChild("ideEstabLot", namespaceeEvt);
            Element infoCategIncid = ideEstabLot.getChild("infoCategIncid", namespaceeEvt);
            List eventos = infoCategIncid.getChildren("infoBaseCS", namespaceeEvt);
            for (Element evt : eventos) {
                String ind = evt.getChildText("ind13", namespaceeEvt);
                String tipoValor = evt.getChildText("tpValor", namespaceeEvt);
                String valor = evt.getChildText("valor", namespaceeEvt);
                EsocItemValoresInss esocItem = new EsocItemValoresInss();
                esocItem.setIndicativoFolha(Short.valueOf(ind));
                esocItem.setTipoValor(tipoValor);
                esocItem.setValor(Double.valueOf(valor));
                esocItem.setEsocValores(esocValores);
                esocValores.getItens().add(esocItem);
            }
            if (eventoLote.getValoresInss() == null) {
                eventoLote.setValoresInss(esocValores);
            }
        }
    }

    private boolean getEventoComIrrf(EsocEvento eventoLote) {
        Long idEvento = eventoLote.getEsocLoteEventos().getTipoEvento().getIdentificador();
        return idEvento.equals(ConstantsESocial.REGISTRO_2299) || idEvento.equals(ConstantsESocial.REGISTRO_1210);
    }

    private void buscarRetornoS5002(EsocEvento eventoLote, Element evento) {
        EsocValoresIrrfColaborador esocIrrf;
        Namespace namespace = ConstantsNamespace.NAMESPACE_RETORNO_PROCESSAMENTO;
        Namespace namespaceeEvt = ConstantsNamespace.NAMESPACE_EVENTO_5002;
        Element retornoEvento = evento.getChild("tot", namespace);
        Element eSocialEvt = retornoEvento.getChild("eSocial", namespaceeEvt);
        Element evtIrrfBenef = eSocialEvt.getChild("evtIrrfBenef", namespaceeEvt);
        Element infoIrrf = evtIrrfBenef.getChild("ideTrabalhador", namespaceeEvt);
        List irrs = infoIrrf.getChildren("dmDev", namespaceeEvt);
        if (eventoLote.getValoresIrrf() == null) {
            esocIrrf = new EsocValoresIrrfColaborador();
            esocIrrf.setPeriodoApuracao(eventoLote.getPreEvento().getEsocS1210().getEsocFechamento().getPeriodoApuracao());
        } else {
            esocIrrf = eventoLote.getValoresIrrf();
            esocIrrf.setItens(new ArrayList());
        }
        Double valorTotal = 0.0;
        for (Element evt : irrs) {
            List eventos = evt.getChildren("infoIR", namespaceeEvt);
            for (Element ev : eventos) {
                String tpCR = ev.getChildText("tpInfoIR", namespaceeEvt);
                String vrIrrfDesc = ev.getChildText("valor", namespaceeEvt);
                if (tpCR.equals("31") || tpCR.equals("32")) {
                    valorTotal = valorTotal + Double.parseDouble(vrIrrfDesc);
                }
                esocIrrf.getItens().add(new EsocItemValoresIrrf(tpCR, Double.valueOf(vrIrrfDesc), esocIrrf));
            }
        }
        esocIrrf.setTotalDescontado(valorTotal);
        if (eventoLote.getValoresIrrf() == null) {
            eventoLote.setValoresIrrf(esocIrrf);
        }
    }

    private boolean getEventoFechamentoPeriodo(EsocEvento eventoLote) {
        Long idEvento = eventoLote.getEsocLoteEventos().getTipoEvento().getIdentificador();
        return idEvento.equals(ConstantsESocial.REGISTRO_1299);
    }

    private void buscarRetornoS5011(EsocEvento eventoLote, Element evento) {
        Namespace namespace = ConstantsNamespace.NAMESPACE_RETORNO_PROCESSAMENTO;
        Namespace namespaceeEvt = ConstantsNamespace.NAMESPACE_EVENTO_5011;
        Double debitoApurado = 0.0;
        Double salarioFamilia = 0.0;
        Double salarioMaternidade = 0.0;
        List tots = evento.getChildren("tot", namespace);
        for (Element ret : tots) {
            Element tot = ret;
            Element eSocialEvt = tot.getChild("eSocial", namespaceeEvt);
            if (eSocialEvt == null) continue;
            EsocValores5011 esocValores5011 = new EsocValores5011();
            Element evtCS = eSocialEvt.getChild("evtCS", namespaceeEvt);
            Element infoCS = evtCS.getChild("infoCS", namespaceeEvt);
            Element infoCPSeg = infoCS.getChild("infoCPSeg", namespaceeEvt);
            Element infoContrib = infoCS.getChild("infoContrib", namespaceeEvt);
            Element infoPJ = infoCS.getChild("infoPJ", namespaceeEvt);
            if (infoPJ != null) {
                Element infoAtConc = infoPJ.getChild("infoAtConc", namespaceeEvt);
                esocValores5011.setFatorMes(Double.valueOf(infoAtConc.getChildText("fatorMes", namespaceeEvt)));
            }
            String valorTotalDescontado = infoCPSeg.getChildText("vrDescCP", namespaceeEvt);
            String valorTotalCalculado = infoCPSeg.getChildText("vrDescCP", namespaceeEvt);
            esocValores5011.setPeriodoApuracao(eventoLote.getPreEvento().getFechamentoEventos().getPeriodoReferencia());
            esocValores5011.setValorTotalCalculado(Double.valueOf(valorTotalCalculado));
            esocValores5011.setValorTotalDescontado(Double.valueOf(valorTotalDescontado));
            esocValores5011.setCodigoClassificacaoTributaria(infoContrib.getChildText("classTrib", namespaceeEvt));
            if (esocValores5011.getValorTotalCalculado() > 0.0) {
                esocValores5011.setExistenciaValores(Short.valueOf((short)1));
            }
            List estabelecimentos = infoCS.getChildren("ideEstab", namespaceeEvt);
            for (Element estabelecimento : estabelecimentos) {
                Object lot2;
                EsocEstabelecimentos5011 estab = new EsocEstabelecimentos5011();
                String numeroCnpj = estabelecimento.getChildText("nrInsc", namespaceeEvt);
                estab.setNumeroCnpj(numeroCnpj);
                List ideLotacoes = estabelecimento.getChildren("ideLotacao", namespaceeEvt);
                for (Object lot2 : ideLotacoes) {
                    EsocLotacaoTributaria5011 lotacao = new EsocLotacaoTributaria5011();
                    List basesRemun = lot2.getChildren("basesRemun", namespaceeEvt);
                    String fpas = lot2.getChildText("fpas", namespaceeEvt);
                    String codTercs = lot2.getChildText("codTercs", namespaceeEvt);
                    String codLotacao = lot2.getChildText("codLotacao", namespaceeEvt);
                    lotacao.setCodigo(codLotacao);
                    lotacao.setFpas(fpas);
                    lotacao.setCodigoTerceiros(codTercs);
                    for (Element elementBase : basesRemun) {
                        EsocBasesRemun5011 base = new EsocBasesRemun5011();
                        String categoria = elementBase.getChildText("codCateg", namespaceeEvt);
                        String indIncid = elementBase.getChildText("indIncid", namespaceeEvt);
                        Element basesCp = elementBase.getChild("basesCp", namespaceeEvt);
                        String vrBcCp00 = basesCp.getChildText("vrBcCp00", namespaceeEvt);
                        String vrBcCp15 = basesCp.getChildText("vrBcCp15", namespaceeEvt);
                        String vrBcCp20 = basesCp.getChildText("vrBcCp20", namespaceeEvt);
                        String vrBcCp25 = basesCp.getChildText("vrBcCp25", namespaceeEvt);
                        String vrDescSest = basesCp.getChildText("vrDescSest", namespaceeEvt);
                        String vrCalcSest = basesCp.getChildText("vrCalcSest", namespaceeEvt);
                        String vrDescSenat = basesCp.getChildText("vrDescSenat", namespaceeEvt);
                        String vrCalcSenat = basesCp.getChildText("vrCalcSenat", namespaceeEvt);
                        String vrSalFam = basesCp.getChildText("vrSalFam", namespaceeEvt);
                        String vrSalMat = basesCp.getChildText("vrSalMat", namespaceeEvt);
                        base.setCodigoCategoria(categoria);
                        base.setIndIncid(indIncid);
                        base.setBcCp00(Double.valueOf(vrBcCp00));
                        base.setBcCp15(Double.valueOf(vrBcCp15));
                        base.setBcCp20(Double.valueOf(vrBcCp20));
                        base.setBcCp25(Double.valueOf(vrBcCp25));
                        base.setIndicativoIncidencia(elementBase.getChildText("indIncid", namespaceeEvt));
                        base.setVlrCalcSenat(Double.valueOf(vrCalcSenat));
                        base.setVlrCalcSest(Double.valueOf(vrCalcSest));
                        base.setVlrDescSenat(Double.valueOf(vrDescSenat));
                        base.setVlrDescSest(Double.valueOf(vrDescSest));
                        base.setVlrSalFamilia(Double.valueOf(vrSalFam));
                        base.setVlrSalMaternidade(Double.valueOf(vrSalMat));
                        salarioFamilia = salarioFamilia + ToolFormatter.arrredondarNumero((Double)base.getVlrSalFamilia(), (int)2);
                        salarioFamilia = ToolFormatter.arrredondarNumero((Double)salarioFamilia, (int)2);
                        salarioMaternidade = salarioMaternidade + ToolFormatter.arrredondarNumero((Double)base.getVlrSalMaternidade(), (int)2);
                        salarioMaternidade = ToolFormatter.arrredondarNumero((Double)salarioMaternidade, (int)2);
                        base.setEsocLotacao(lotacao);
                        lotacao.getBasesRetorno().add(base);
                    }
                    lotacao.setEstabelecimento(estab);
                    estab.getLotacoes().add(lotacao);
                }
                List infoCREstab = estabelecimento.getChildren("infoCREstab", namespaceeEvt);
                lot2 = infoCREstab.iterator();
                while (lot2.hasNext()) {
                    Element element = (Element)lot2.next();
                    String tpCR = element.getChildText("tpCR", namespaceeEvt);
                    String vrCR = element.getChildText("vrCR", namespaceeEvt);
                    EsocValoresContSociaisDevidas cont = new EsocValoresContSociaisDevidas();
                    cont.setCodigoReceita(tpCR);
                    cont.setValor(Double.valueOf(vrCR));
                    cont.setValorSuspenso(Double.valueOf(0.0));
                    cont.setEsocEstabelecimento(estab);
                    estab.getValoresDevidos().add(cont);
                }
                List basesAquis = estabelecimento.getChildren("basesAquis", namespaceeEvt);
                for (Element basesAqui : basesAquis) {
                    String indAquisicao = basesAqui.getChildText("indAquisicao", namespaceeEvt);
                    String vlrAquis = basesAqui.getChildText("vlrAquis", namespaceeEvt);
                    String vrCPDescPR = basesAqui.getChildText("vrCPDescPR", namespaceeEvt);
                    String vrCPCalcPR = basesAqui.getChildText("vrCPCalcPR", namespaceeEvt);
                    String vrRatDescPR = basesAqui.getChildText("vrRatDescPR", namespaceeEvt);
                    String vrRatCalcPR = basesAqui.getChildText("vrRatCalcPR", namespaceeEvt);
                    String vrSenarDesc = basesAqui.getChildText("vrSenarDesc", namespaceeEvt);
                    String vrSenarCalc = basesAqui.getChildText("vrSenarCalc", namespaceeEvt);
                    EsocBasesAquiProdRural esocRural = new EsocBasesAquiProdRural();
                    esocRural.setIndAquisicao(indAquisicao);
                    esocRural.setVlrAquis(Double.valueOf(vlrAquis));
                    esocRural.setVrCPDescPR(Double.valueOf(vrCPDescPR));
                    esocRural.setVlrCpCalcPR(Double.valueOf(vrCPCalcPR));
                    esocRural.setVrRatDescPR(Double.valueOf(vrRatDescPR));
                    esocRural.setVrRatCalcPR(Double.valueOf(vrRatCalcPR));
                    esocRural.setVrSenarDesc(Double.valueOf(vrSenarDesc));
                    esocRural.setVrSenarCalc(Double.valueOf(vrSenarCalc));
                    esocRural.setEsocEstabelecimento(estab);
                    estab.getBasesAquiProdRural().add(esocRural);
                }
                estab.setEsocValores(esocValores5011);
                esocValores5011.getEstabelecimentos().add(estab);
            }
            List infoCRContrib = infoCS.getChildren("infoCRContrib", namespaceeEvt);
            for (Element element : infoCRContrib) {
                String tpCR = element.getChildText("tpCR", namespaceeEvt);
                String vrCR = element.getChildText("vrCR", namespaceeEvt);
                EsocValoresOutrasEntidades cont = new EsocValoresOutrasEntidades();
                cont.setCodigoReceita(tpCR);
                cont.setValor(Double.valueOf(vrCR));
                debitoApurado = debitoApurado + ToolFormatter.arrredondarNumero((Double)cont.getValor(), (int)2);
                debitoApurado = ToolFormatter.arrredondarNumero((Double)debitoApurado, (int)2);
                cont.setValorSuspenso(Double.valueOf(0.0));
                cont.setEsocValores(esocValores5011);
                esocValores5011.getEsocValoresOutrasEntidades().add(cont);
            }
            esocValores5011.setDebitoApurado(debitoApurado);
            esocValores5011.setTotalSalFamilia(salarioFamilia);
            esocValores5011.setTotalSalMaternidade(salarioMaternidade);
            esocValores5011.setSaldoAPagar(ToolFormatter.arrredondarNumero((Double)(esocValores5011.getDebitoApurado() - esocValores5011.getTotalSalFamilia() - esocValores5011.getTotalSalMaternidade()), (int)2));
            if (eventoLote.getEsocTotalizadorInss() != null) continue;
            eventoLote.setEsocTotalizadorInss(esocValores5011);
        }
    }

    private void verificarStatusRetornoVersao(EsocEvento eventoLote, Element evento, Namespace namespaceeEvt, Element retornoEvento) {
        Element eSocialEvt = retornoEvento.getChild("eSocial", namespaceeEvt);
        Element retornoEventoEvt = eSocialEvt.getChild("retornoEvento", namespaceeEvt);
        Element processamento = retornoEventoEvt.getChild("processamento", namespaceeEvt);
        eventoLote.setStatus(Long.valueOf(processamento.getChildText("cdResposta", namespaceeEvt)));
        if (ToolMethods.isEquals((Object)eventoLote.getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue()) || ToolMethods.isEquals((Object)eventoLote.getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) {
            Element recibo = retornoEventoEvt.getChild("recibo", namespaceeEvt);
            eventoLote.setNrRecibo(recibo.getChildText("nrRecibo", namespaceeEvt));
            this.verificarRetornoImposto(eventoLote, evento);
        }
        eventoLote.setDescricaoStatus(processamento.getChildText("descResposta", namespaceeEvt));
        eventoLote.setDataHoraProcessamento(processamento.getChildText("dhProcessamento", namespaceeEvt));
        Element ocorrencia = processamento.getChild("ocorrencias", namespaceeEvt);
        StringBuilder sb = new StringBuilder();
        if (ocorrencia != null && ocorrencia.getChildren("ocorrencia", namespaceeEvt) != null) {
            List ocorrencias = ocorrencia.getChildren("ocorrencia", namespaceeEvt);
            ocorrencias.forEach(item -> {
                sb.append("Ocorrencita tipo ").append(item.getChildText("tipo", namespaceeEvt)).append(", Codigo: ").append(item.getChildText("codigo", namespaceeEvt)).append("\n");
                sb.append(item.getChildText("descricao", namespaceeEvt));
                sb.append("\n\n");
            });
        } else {
            sb.append("Ocorrencia tipo ").append(eventoLote.getStatus().toString()).append("\n");
            sb.append(eventoLote.getDescricaoStatus());
            sb.append("\n\n");
        }
        eventoLote.setDescricaoStatusDetalhada(sb.toString());
    }
}

