/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.consultapessoas.impl;

import com.touchcomp.basementorclientwebservices.consultapessoas.WEBConsultaPessoas;
import com.touchcomp.basementorclientwebservices.consultapessoas.constants.ConstEnumConsultaPessoasRegTrib;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsultaPessoaParams;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsutalPessoaResp;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class WEBConsultaPessoasBrasilAPI {
    private final String URL = "https://brasilapi.com.br/api/cnpj/v1/";
    private final String URL_FILE_MUN = "http://www.touchcomp.com.br/mentor/touch_comp_erp/codigo_municipios_TOM_receita_federal.csv";

    public DTOConsutalPessoaResp consultaDados(DTOConsultaPessoaParams param, WEBConsultaPessoas.Config config) throws ExceptionIO, ExceptionInvalidState {
        if (ToolMethods.isStrWithData((String)param.getInscricaoEstadual())) {
            throw new ExceptionInvalidState("E.ERP.0047.057", new Object[0]);
        }
        if (param.getCpfCnpj().length() >= 14) {
            return this.consultaCnpj(param.getCpfCnpj(), config);
        }
        throw new ExceptionInvalidState("E.ERP.0047.057", new Object[0]);
    }

    private DTOConsutalPessoaResp consultaCnpj(String cpfCnpj, WEBConsultaPessoas.Config config) throws ExceptionIO {
        DTOConsutalPessoaResp dTOConsutalPessoaResp;
        block9: {
            cpfCnpj = ToolString.onlyNumbers((String)cpfCnpj);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
            Request request = new Request.Builder().url("https://brasilapi.com.br/api/cnpj/v1/" + cpfCnpj).get().build();
            Response response = client.newCall(request).execute();
            try {
                String ret = response.body().string();
                Map m = ToolJson.readJsonAsMap((String)ret);
                dTOConsutalPessoaResp = this.converterRetorno(m);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new ExceptionIO((IOException)ex);
                }
                catch (IOException ex) {
                    throw new ExceptionIO(ex);
                }
            }
            response.close();
        }
        return dTOConsutalPessoaResp;
    }

    DTOConsutalPessoaResp converterRetorno(Map<String, Object> response) throws ExceptionIO {
        DTOConsutalPessoaResp resp = new DTOConsutalPessoaResp();
        Boolean erro = (Boolean)response.get("error");
        if (erro == null) {
            erro = false;
        }
        String message = (String)response.get("message");
        resp.setDescricaoRetorno(message);
        resp.setErro(erro);
        if (erro.booleanValue()) {
            return resp;
        }
        String cnpj = (String)response.get("cnpj");
        Integer matriz_filial = (Integer)response.get("identificador_matriz_filial");
        String nome_fantasia = (String)response.get("nome_fantasia");
        String data_situacao_cadastral = (String)response.get("data_situacao_cadastral");
        String motivo_situacao_cadastral = (String)response.get("descricao_situacao_cadastral");
        Integer situacao_cadastral = (Integer)response.get("situacao_cadastral");
        String data_inicio_atividades = (String)response.get("data_inicio_atividade");
        Integer cnae_fiscal = (Integer)response.get("cnae_fiscal");
        Double capital_social = response.get("capital_social") != null ? ((Number)response.get("capital_social")).doubleValue() : 0.0;
        String razao_social = (String)response.get("razao_social");
        DTOConsutalPessoaResp.Pessoa pessoa = new DTOConsutalPessoaResp.Pessoa();
        pessoa.setCapitalSocial(capital_social);
        pessoa.setCnaePrincipal(String.valueOf(cnae_fiscal));
        pessoa.setCpfCnpj(cnpj);
        data_inicio_atividades = ToolString.onlyNumbers((String)data_inicio_atividades);
        data_situacao_cadastral = ToolString.onlyNumbers((String)data_situacao_cadastral);
        if (data_inicio_atividades != null && data_inicio_atividades.length() == 8) {
            pessoa.setDataInicioAtividades(ToolDate.strToDate((String)data_inicio_atividades, (String)"yyyyMMdd"));
        }
        if (data_situacao_cadastral != null && data_situacao_cadastral.length() == 8) {
            pessoa.setDataSituacaoCadastral(ToolDate.strToDate((String)data_situacao_cadastral, (String)"yyyyMMdd"));
        }
        if (matriz_filial != null) {
            pessoa.setMatriz(matriz_filial.shortValue());
        }
        pessoa.setMotivoSituacaoCadastral(motivo_situacao_cadastral);
        pessoa.setSituacaoCadastral(String.valueOf(situacao_cadastral));
        pessoa.setNome(razao_social);
        pessoa.setNomeFantasia(nome_fantasia);
        resp.getPessoas().add(pessoa);
        String telefone1 = (String)response.get("ddd_telefone_1");
        String telefone2 = (String)response.get("ddd_telefone_2");
        String email = (String)response.get("email");
        DTOConsutalPessoaResp.Contato contato = new DTOConsutalPessoaResp.Contato();
        contato.setEmail(email);
        contato.setTelefone1(telefone1);
        contato.setTelefone2(telefone2);
        pessoa.setContato(contato);
        String tipo_logradouro = (String)response.get("descricao_tipo_de_logradouro");
        String logradouro = (String)response.get("logradouro");
        String numero = (String)response.get("numero");
        String complemento = (String)response.get("complemento");
        String bairro = (String)response.get("bairro");
        String cep = (String)response.get("cep");
        String uf = (String)response.get("uf");
        Integer codigoCid = (Integer)response.get("codigo_municipio");
        Integer codigoCidIBGE = (Integer)response.get("codigo_municipio_ibge");
        String cidade = (String)response.get("municipio");
        DTOConsutalPessoaResp.Endereco endereco = new DTOConsutalPessoaResp.Endereco();
        endereco.setBairro(bairro);
        endereco.setCep(cep);
        endereco.setCodigoMunicipio(String.valueOf(codigoCidIBGE));
        endereco.setCodigoMunicipioReceita(String.valueOf(codigoCid));
        endereco.setComplemento(complemento);
        endereco.setLogradouro(tipo_logradouro + " " + logradouro);
        endereco.setMunicipio(cidade);
        endereco.setNumero(numero);
        endereco.setTipoLogradouro(tipo_logradouro);
        endereco.setUf(uf);
        pessoa.setEndereco(endereco);
        Boolean opcaoSimples = (Boolean)response.get("opcao_pelo_simples");
        Boolean opcaoMei = (Boolean)response.get("opcao_pelo_mei");
        ConstEnumConsultaPessoasRegTrib regime = ConstEnumConsultaPessoasRegTrib.NORMAL;
        Date dataOpcao = null;
        if (opcaoSimples != null && opcaoSimples.booleanValue()) {
            String data_opcao_simples = (String)response.get("data_opcao_simples");
            regime = ConstEnumConsultaPessoasRegTrib.SIMPLES;
            if (data_opcao_simples != null && data_opcao_simples.length() == 8) {
                dataOpcao = ToolDate.strToDate((String)data_opcao_simples, (String)"yyyyMMdd");
            }
        } else if (opcaoMei != null && opcaoMei.booleanValue()) {
            String data_opcao_mei = (String)response.get("data_opcao_mei");
            regime = ConstEnumConsultaPessoasRegTrib.MEI;
            if (data_opcao_mei.length() == 8) {
                dataOpcao = ToolDate.strToDate((String)data_opcao_mei, (String)"yyyyMMdd");
            }
        }
        DTOConsutalPessoaResp.Tributacao tributacao = new DTOConsutalPessoaResp.Tributacao();
        tributacao.setRegimeTrib(regime);
        tributacao.setDataOpcao(dataOpcao);
        pessoa.setTributacao(tributacao);
        List socios = (List)response.get("qsa");
        LinkedList<DTOConsutalPessoaResp.Socio> aux = new LinkedList<DTOConsutalPessoaResp.Socio>();
        for (Map socio : socios) {
            String cnpj_cpf_socio = (String)socio.get("cnpj_cpf_do_socio");
            String codigo_qualificacao_socio = (String)socio.get("qualificacao_socio");
            String nome_socio = (String)socio.get("nome_socio");
            DTOConsutalPessoaResp.Socio s = new DTOConsutalPessoaResp.Socio();
            s.setCodigoQualificacao(codigo_qualificacao_socio);
            s.setCpfCnpj(cnpj_cpf_socio);
            s.setNome(nome_socio);
            Map qualificacao = (Map)socio.get("qualificacao");
            if (qualificacao != null) {
                String descricao = (String)qualificacao.get("descricao");
                s.setQualificacao(descricao);
            }
            aux.add(s);
        }
        pessoa.setSocios(aux);
        return resp;
    }
}

