/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1;

import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.ZenviaInterceptor;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.model.ZenviaConfig;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class ZenviaSender {
    private ZenviaConfig zenviaConfig;
    private final String DEFAULT_BASE_URL = "https://api-rest.zenvia.com/services/";
    private final String DEFAULT_BRAZIL_DDI = "55";

    public Retrofit getRetrofit(ZenviaConfig config) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor((Interceptor)new ZenviaInterceptor(config.getUsuario(), config.getSenha()));
        OkHttpClient client = httpClient.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.getBaseUrl(config)).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return retrofit;
    }

    public ZenviaConfig getConfig() {
        return this.zenviaConfig;
    }

    public void setConfig(ZenviaConfig zenviaConfig) {
        this.zenviaConfig = zenviaConfig;
    }

    private String getBaseUrl(ZenviaConfig config) {
        if (ToolMethods.isStrWithData((String)config.getBaseUrl())) {
            return config.getBaseUrl();
        }
        return "https://api-rest.zenvia.com/services/";
    }

    public String normalizarNrTelefone(String nr) {
        if (nr == null) {
            return nr;
        }
        if (((String)(nr = ToolString.onlyNumbers((String)nr))).startsWith("55")) {
            nr = ((String)nr).substring("55".length());
        }
        while (((String)nr).startsWith("0")) {
            nr = ((String)nr).substring(1);
        }
        if (!((String)nr).startsWith("55")) {
            nr = "55" + (String)nr;
        }
        return nr;
    }
}

