/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtadmprelim;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.RegistroAdmissaoPreLiminar;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmprelim.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmprelim.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmprelim.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtadmprelim.v_s_01_03_00.TIdeEventoTrabAdmissao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;

public class ImpEvtAdmPreLim
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        RegistroAdmissaoPreLiminar r = preEvento.getAdmissaoPreLiminar();
        ESocial root = this.getFact().createESocial();
        root.setEvtAdmPrelim(this.getEventoPreLiminar(preEvento, r, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAdmPrelim getEventoPreLiminar(EsocPreEvento preEvento, RegistroAdmissaoPreLiminar r, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAdmPrelim evt = this.getFact().createESocialEvtAdmPrelim();
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setInfoRegPrelim(this.getRegistroPreLiminar(r));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private ESocial.EvtAdmPrelim.InfoRegPrelim getRegistroPreLiminar(RegistroAdmissaoPreLiminar r) {
        ESocial.EvtAdmPrelim.InfoRegPrelim infoPreLiminar = this.getFact().createESocialEvtAdmPrelimInfoRegPrelim();
        infoPreLiminar.setCpfTrab(ToolString.refina((String)r.getCpf()));
        infoPreLiminar.setDtNascto(ToolEsocial.converteData(r.getDataNascimento()));
        infoPreLiminar.setDtAdm(ToolEsocial.converteData(r.getDataAdmissao()));
        infoPreLiminar.setCodCateg(new BigInteger(r.getEsocCategoria().getCodigo()));
        infoPreLiminar.setMatricula(r.getMatricula());
        infoPreLiminar.setNatAtividade(Byte.valueOf(r.getNaturezaAtividade().getCodigo()));
        infoPreLiminar.setInfoRegCTPS(this.getInfoCTPS(r));
        return infoPreLiminar;
    }

    private ESocial.EvtAdmPrelim.InfoRegPrelim.InfoRegCTPS getInfoCTPS(RegistroAdmissaoPreLiminar r) {
        ESocial.EvtAdmPrelim.InfoRegPrelim.InfoRegCTPS i = this.getFact().createESocialEvtAdmPrelimInfoRegPrelimInfoRegCTPS();
        i.setCBOCargo(ToolString.refina((String)r.getFuncao().getCbo().getCodigo()));
        i.setVrSalFx(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getSalario(), (int)2));
        i.setUndSalFixo(Byte.parseByte(r.getTipoSalario().getCodigoEsocial()));
        i.setTpContr(Byte.parseByte(r.getTipoContrato().toString()));
        if (!r.getTipoContrato().equals(ConstantsESocial.CONTRATO_INDETERMINADO)) {
            i.setDtTerm(ToolEsocial.converteData(r.getDataTermino()));
        }
        return i;
    }

    private TIdeEventoTrabAdmissao getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoTrabAdmissao cadastro = this.getFact().createTIdeEventoTrabAdmissao();
        cadastro.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        cadastro.setIndRetif(Byte.parseByte("1"));
        return cadastro;
    }
}

