/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtaltcadastral;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TContato;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TEnderecoBrasil;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TSSexo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcadastral.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

public class ImpEvtAltCadastral
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        Colaborador colaborador = preEvento.getColaborador();
        ESocial root = this.getFact().createESocial();
        root.setEvtAltCadastral(this.getEvtAltCadastral(colaborador, preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAltCadastral getEvtAltCadastral(Colaborador colaborador, EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAltCadastral evt = this.getFact().createESocialEvtAltCadastral();
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEvento(this.getTiCadastro(preEvento.getEsocEvento(), opcoes));
        evt.setIdeTrabalhador(this.getIdeTrabalhador(colaborador));
        evt.setAlteracao(this.getAlteracao(colaborador, preEvento));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getTiCadastro(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtAltCadastral.IdeTrabalhador getIdeTrabalhador(Colaborador colaborador) {
        ESocial.EvtAltCadastral.IdeTrabalhador trabalhador = this.getFact().createESocialEvtAltCadastralIdeTrabalhador();
        trabalhador.setCpfTrab(colaborador.getPessoa().getComplemento().getCnpj());
        return trabalhador;
    }

    private ESocial.EvtAltCadastral.Alteracao getAlteracao(Colaborador colaborador, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtAltCadastral.Alteracao alteracao = this.getFact().createESocialEvtAltCadastralAlteracao();
        alteracao.setDtAlteracao(ToolEsocial.converteData(preEvento.getDataInicioVal()));
        alteracao.setDadosTrabalhador(this.getDadosTrabalhador(colaborador));
        return alteracao;
    }

    private ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador getDadosTrabalhador(Colaborador colaborador) throws ExceptionEsocial {
        ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador trabalhador = this.getFact().createESocialEvtAltCadastralAlteracaoDadosTrabalhador();
        trabalhador.setNmTrab(colaborador.getPessoa().getNome());
        trabalhador.setSexo(this.getSexo(colaborador.getSexo(), colaborador.getPessoa().getNome()));
        trabalhador.setRacaCor(Byte.parseByte(colaborador.getRacaCor().getCodigoEsocial()));
        if (colaborador.getEstadoCivil() != null) {
            trabalhador.setEstCiv(Byte.valueOf(colaborador.getEstadoCivil().getCodigoEsocial()));
        }
        trabalhador.setGrauInstr(colaborador.getGrauInstrucao().getCodigo());
        if (colaborador.getNomeSocialTravesti() != null && colaborador.getNomeSocialTravesti().length() > 0) {
            trabalhador.setNmSoc(colaborador.getNomeSocialTravesti());
        }
        trabalhador.setEndereco(this.getEndereco(colaborador));
        if (!colaborador.getNacionalidade().getCodigoESocial().equals("105")) {
            // empty if block
        }
        if (colaborador.getTipoDeficiencia() != null) {
            trabalhador.setInfoDeficiencia(this.getInfoDeficiencia(colaborador));
        }
        trabalhador.setPaisNac(colaborador.getNacionalidade().getCodigoESocial());
        HelperColaborador helper = new HelperColaborador();
        List deps = helper.build(colaborador).getDependentesSalFamIRRF(new Date());
        for (ColaboradorDependente dep : deps) {
            ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador.Dependente d = this.getFact().createESocialEvtAltCadastralAlteracaoDadosTrabalhadorDependente();
            d.setTpDep(dep.getTipoDependente().getCodigo());
            d.setNmDep(ToolString.clearInvalidUTF8Char((String)dep.getNomeDependente()));
            d.setDtNascto(ToolEsocial.converteData(dep.getDataNascimento()));
            if (ToolMethods.isStrWithData((String)dep.getCpf())) {
                d.setCpfDep(ToolString.refina((String)dep.getCpf()));
            }
            d.setDepSF(this.getSimOrNao(dep.getDependenteSalarioFamilia()));
            d.setDepIRRF(this.getSimOrNao(dep.getDependenteIRRF()));
            d.setIncTrab(this.getSimOrNao(dep.getDependenteIncapacitado()));
            trabalhador.getDependente().add(d);
        }
        if (colaborador.getContato() != null && colaborador.getContato().length() > 0) {
            trabalhador.setContato(this.getContato(colaborador));
        }
        return trabalhador;
    }

    private TSSexo getSexo(Short sexo, String nome) throws ExceptionEsocial {
        if (sexo == null) {
            throw new ExceptionEsocial("Dependente: " + nome + " n\u00ef\u00bf\u00bdo foi informado o Sexo do mesmo.");
        }
        if (sexo.equals((short)1)) {
            return TSSexo.F;
        }
        return TSSexo.M;
    }

    private ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador.Endereco getEndereco(Colaborador colaborador) {
        ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador.Endereco endereco = this.getFact().createESocialEvtAltCadastralAlteracaoDadosTrabalhadorEndereco();
        if (colaborador.getNacionalidade().getCodigoESocial().equals("105")) {
            endereco.setBrasil(this.getEnderecoBrasil(colaborador));
        }
        return endereco;
    }

    private TEnderecoBrasil getEnderecoBrasil(Colaborador colaborador) {
        TEnderecoBrasil endereco = this.getFact().createTEnderecoBrasil();
        endereco.setBairro(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getBairro()));
        endereco.setCep(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getCep()));
        endereco.setCodMunic(new BigInteger(colaborador.getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        if (colaborador.getPessoa().getEndereco().getComplemento() != null && colaborador.getPessoa().getEndereco().getComplemento().length() > 0) {
            endereco.setComplemento(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getComplemento()));
        }
        endereco.setDscLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getLogradouro()));
        endereco.setNrLograd(colaborador.getPessoa().getEndereco().getNumero());
        endereco.setTpLograd(colaborador.getTipoLogradouroEndereco().getSigla());
        endereco.setUf(TSUf.fromValue(colaborador.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        return endereco;
    }

    private ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador.InfoDeficiencia getInfoDeficiencia(Colaborador colaborador) {
        ESocial.EvtAltCadastral.Alteracao.DadosTrabalhador.InfoDeficiencia infoDeficiencia = this.getFact().createESocialEvtAltCadastralAlteracaoDadosTrabalhadorInfoDeficiencia();
        if (colaborador.getTipoDeficiencia().getCodigo().equals("2")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.S);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("1")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.S);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("7")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.S);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("4")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.S);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("6")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.S);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("3")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.S);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        }
        infoDeficiencia.setInfoCota(this.getSimOrNao(colaborador.getColaboradorIncapaz()));
        return infoDeficiencia;
    }

    private TContato getContato(Colaborador colaborador) {
        TContato contato = this.getFact().createTContato();
        if (colaborador.getPessoa().getComplemento().getFone1() != null && colaborador.getPessoa().getComplemento().getFone1().length() > 0) {
            contato.setFonePrinc(ToolString.refina((String)colaborador.getPessoa().getComplemento().getFone1()));
        }
        if (colaborador.getPessoa().getComplemento().getCel1() != null && colaborador.getPessoa().getComplemento().getCel1().length() > 0) {
            contato.setFonePrinc(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCel1()));
        }
        if (colaborador.getPessoa().getComplemento().getEmailPrincipal() != null && colaborador.getPessoa().getComplemento().getEmailPrincipal().length() > 0) {
            contato.setEmailPrinc(colaborador.getPessoa().getComplemento().getEmailPrincipal());
        }
        return contato;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }
}

