/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtpagdesligamentocomplementar;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConvenioPlanoSaude;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ItemIntegracaoContratoIntermitente;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.MultiplosVinculosFolha;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RecisaoComplementar;
import com.touchcomp.basementor.model.vo.RecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TIdeEventoFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TInfoAgNocivo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TInfoInterm;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TItensRemun;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TItensRemunDescFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TSTpAcConv;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtDesligamentoComplementar
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtRemun(this.getEvtRemuneracao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtRemun getEvtRemuneracao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        Recisao r = preEvento.getRecisao();
        ESocial.EvtRemun evt = this.getFact().createESocialEvtRemun();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evt.setIdeTrabalhador(this.getEvtTrabalhador(preEvento));
        evt.getDmDev().add(this.getDmDev(r, opcoes, preEvento));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoFolha getIdEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        TIdeEventoFolha tiTrab = this.getFact().createTIdeEventoFolha();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(preEvento.getEventoAnterior().getEsocEvento().getNrRecibo());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        tiTrab.setIndApuracao(Byte.parseByte("1"));
        tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getRecisao().getRecisaoComplementarAc().getDataPagamento(), (String)"yyyy-MM"));
        return tiTrab;
    }

    private ESocial.EvtRemun.IdeTrabalhador getEvtTrabalhador(EsocPreEvento preEvento) {
        ESocial.EvtRemun.IdeTrabalhador evt = this.getFact().createESocialEvtRemunIdeTrabalhador();
        Recisao r = preEvento.getRecisao();
        evt.setCpfTrab(ToolString.refina((String)r.getColaborador().getPessoa().getComplemento().getCnpj()));
        if (r.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            evt.getInfoInterm().add(this.getInfoIntermitente());
        }
        return evt;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoMV getMultiplosVinculos(MovimentoFolha mov) {
        ESocial.EvtRemun.IdeTrabalhador.InfoMV m = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoMV();
        m.setIndMV(Byte.parseByte(mov.getEsocIndInssMv().getCodigo()));
        for (MultiplosVinculosFolha mul : mov.getMultiplosVinculos()) {
            m.getRemunOutrEmpr().add(this.dadosOutrasEmpresas(mul));
        }
        return m;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoMV.RemunOutrEmpr dadosOutrasEmpresas(MultiplosVinculosFolha mul) {
        ESocial.EvtRemun.IdeTrabalhador.InfoMV.RemunOutrEmpr remuneracao = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoMVRemunOutrEmpr();
        remuneracao.setTpInsc(Byte.parseByte("1"));
        remuneracao.setNrInsc(ToolString.refina((String)mul.getCnpj()));
        remuneracao.setCodCateg(new BigInteger(mul.getEsocCategoria().getCodigo()));
        remuneracao.setVlrRemunOE(ToolFormatter.arrredondarNumeroBigDecimal((Double)mul.getValorRemuneracaoRecebida(), (int)2));
        return remuneracao;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoComplem.SucessaoVinc getSucessaoVinculo(TransferenciaColaborador t) {
        ESocial.EvtRemun.IdeTrabalhador.InfoComplem.SucessaoVinc s = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoComplemSucessaoVinc();
        s.setMatricAnt(t.getMatriculaAnterior());
        s.setDtAdm(ToolEsocial.converteData(t.getColaborador().getDataAdmissao()));
        if (t.getObservacao() != null && t.getObservacao().length() > 1) {
            s.setObservacao(t.getObservacao());
        }
        return s;
    }

    private ESocial.EvtRemun.DmDev getDmDev(Recisao r, OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev dmDev = this.getFact().createESocialEvtRemunDmDev();
        dmDev.setIdeDmDev(r.getIdentificador().toString());
        dmDev.setCodCateg(new BigInteger(r.getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
        dmDev.setInfoPerAnt(this.getInfoPeriodoAnterior(r, opcoes));
        if (preEvento.getMovimentoFolhaRecisao() != null) {
            dmDev.setInfoPerApur(this.getInfoPeriodoApuracao(preEvento.getMovimentoFolhaRecisao(), opcoes));
        }
        return dmDev;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur getRemuneracaoPeriodo(MovimentoFolha mov, OpcoesESocial opcoes) {
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur remuneracao = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLotRemunPerApur();
        if (mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("101") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            remuneracao.setMatricula(mov.getColaborador().getNumeroRegistroESocial());
        }
        ConvenioPlanoSaude convenio = null;
        Double valorTotalPlano = 0.0;
        List<Rubricas1200> rubricas = null;
        rubricas = this.rubricasOrdenadas(mov.getRubricas1200());
        for (Rubricas1200 r : rubricas) {
            System.err.println(r.getTipoCalculo().getEsocTipoRubrica().getCodigo());
            if (!r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA) && r.getValorRubrica() > 0.0) {
                remuneracao.getItensRemun().add(this.getItemRemuneracao(r));
            }
            if (!r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_RUBRICA_PLANO_SAUDE) || !(r.getValorRubrica() > 0.0) || r.getTipoCalculo().getConvenioPlanoSaude() == null) continue;
            convenio = r.getTipoCalculo().getConvenioPlanoSaude();
            valorTotalPlano = valorTotalPlano + r.getValorRubrica();
        }
        if (mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("101") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            remuneracao.setInfoAgNocivo(this.getInfoAgNocivo(mov.getColaborador()));
        }
        if (mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            for (ItemIntegracaoContratoIntermitente itemIntegracaoContratoIntermitente : mov.getContratoIntermitente()) {
            }
        }
        return remuneracao;
    }

    private TItensRemunDescFolha getItemRemuneracao(Rubricas1200 r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TItensRemunDescFolha det = this.getFact().createTItensRemunDescFolha();
        det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
        det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        det.setIndApurIR(Byte.valueOf("0"));
        return det;
    }

    private TItensRemun getVerbaImposto(Double valor, Double aliquota, TipoCalculoEvento tp) {
        TItensRemun d = this.getFact().createTItensRemun();
        d.setCodRubr(tp.getEvento().getCodigo().toString());
        d.setIdeTabRubr(tp.getEvento().getIdentificador().toString());
        d.setFatorRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)aliquota, (int)2));
        d.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)valor, (int)2));
        return d;
    }

    private TInfoAgNocivo getInfoAgNocivo(Colaborador colaborador) {
        TInfoAgNocivo infoAg = this.getFact().createTInfoAgNocivo();
        infoAg.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAg;
    }

    private List<Rubricas1200> rubricasOrdenadas(List<Rubricas1200> rubricas1200) {
        if (rubricas1200 != null) {
            Collections.sort(rubricas1200, (o1, o2) -> {
                Rubricas1200 item1 = (Rubricas1200)o1;
                Rubricas1200 item2 = (Rubricas1200)o2;
                Integer vlr1 = Integer.valueOf(item1.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                Integer vlr2 = Integer.valueOf(item2.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                return vlr2.compareTo(vlr1);
            });
            return rubricas1200;
        }
        return null;
    }

    private ESocial.EvtRemun.DmDev.InfoComplCont getInfoComp(EsocItemS1010 item) {
        ESocial.EvtRemun.DmDev.InfoComplCont i = this.getFact().createESocialEvtRemunDmDevInfoComplCont();
        i.setCodCBO(ToolString.refina((String)item.getMovimentoFolha().getColaborador().getFuncao().getCbo().getCodigo()));
        return i;
    }

    private boolean getColaboradorNaoEnviado(Colaborador colaborador) {
        if (colaborador.getPreEventosEsocial().isEmpty()) {
            return true;
        }
        for (EsocPreEvento preEvento : colaborador.getPreEventosEsocial()) {
            if (!preEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2300) || preEvento.getEsocEvento() == null || !ToolMethods.isEquals((Object)preEvento.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !ToolMethods.isEquals((Object)preEvento.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
            return false;
        }
        return true;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt getInfoPeriodoAnterior(Recisao r, OpcoesESocial opcoes) {
        ESocial.EvtRemun.DmDev.InfoPerAnt infoPeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerAnt();
        infoPeriodo.getIdeADC().add(this.getIdeAC(r, opcoes));
        return infoPeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC getIdeAC(Recisao r, OpcoesESocial opcoes) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC ideAdc = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADC();
        RecisaoComplementar rComp = r.getRecisaoComplementarAc();
        ideAdc.setDtAcConv(ToolEsocial.converteData(rComp.getDataAcordo()));
        ideAdc.setTpAcConv(this.createTpAcordo(rComp.getTipoAcordoConvencao().getCodigo()));
        ideAdc.setDsc("PAGAMENTO RESCIS\u00ef\u00bf\u00bdO COMPLEMENTAR");
        for (RecisaoComplementarPeriodo folhaComp : rComp.getRecisaoPeriodo()) {
            ideAdc.getIdePeriodo().add(this.getPeriodoAnterior(folhaComp, opcoes));
        }
        ideAdc.setRemunSuc(this.createSimNao());
        return ideAdc;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo getPeriodoAnterior(RecisaoComplementarPeriodo folhaComp, OpcoesESocial opcoes) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo idePeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodo();
        idePeriodo.setPerRef(ToolDate.formatDateAnoMes((Date)folhaComp.getPeriodo()));
        idePeriodo.getIdeEstabLot().add(this.getIdeEstabelecimentoAnterior(folhaComp, folhaComp.getRecisaoComplementar().getRecisaoOriginal().getColaborador().getLotacaoTributaria(), opcoes));
        return idePeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot getIdeEstabelecimentoAnterior(RecisaoComplementarPeriodo folhaComp, EsocCadastroLotacaoTributaria lotacao, OpcoesESocial opcoes) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot ideEstabelecimento = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodoIdeEstabLot();
        ideEstabelecimento.setCodLotacao(lotacao.getCodigo());
        ideEstabelecimento.setTpInsc(Byte.parseByte("1"));
        ideEstabelecimento.setNrInsc(ToolString.refina((String)folhaComp.getRecisaoComplementar().getRecisaoOriginal().getEmpresa().getPessoa().getComplemento().getCnpj()));
        ideEstabelecimento.getRemunPerAnt().add(this.getRemuneracaoAnterior(folhaComp, opcoes.getEmpresaRh()));
        return ideEstabelecimento;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot.RemunPerAnt getRemuneracaoAnterior(RecisaoComplementarPeriodo folhaComp, EmpresaRh empresaRh) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot.RemunPerAnt remunAnt = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodoIdeEstabLotRemunPerAnt();
        remunAnt.setMatricula(folhaComp.getRecisaoComplementar().getRecisaoOriginal().getColaborador().getNumeroRegistroESocial());
        remunAnt.setInfoAgNocivo(this.getInfoAgNocivoAnterior(folhaComp.getRecisaoComplementar().getRecisaoOriginal().getColaborador()));
        if (!folhaComp.getRecisaoComplementar().getRecisaoOriginal().getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111") || !folhaComp.getRecisaoComplementar().getRecisaoOriginal().getConvocacao().isEmpty()) {
            // empty if block
        }
        for (Rubricas1200 r : folhaComp.getRubricas1200()) {
            remunAnt.getItensRemun().add(this.getRubrica1200Anterior(r));
        }
        return remunAnt;
    }

    private TInfoAgNocivo getInfoAgNocivoAnterior(Colaborador colaborador) {
        TInfoAgNocivo infoAgNocivo = this.getFact().createTInfoAgNocivo();
        infoAgNocivo.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAgNocivo;
    }

    private TItensRemun getRubrica1200Anterior(Rubricas1200 r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TItensRemun det = this.getFact().createTItensRemun();
        det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
        det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        det.setIndApurIR(Byte.valueOf("0"));
        return det;
    }

    private TItensRemun getRubricaImposto(Double valor, TipoCalculoEvento tipoCalculo) {
        TItensRemun det = this.getFact().createTItensRemun();
        det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
        det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)valor, (int)2));
        return det;
    }

    private TInfoInterm getInfoIntermitente() {
        TInfoInterm i = this.getFact().createTInfoInterm();
        Integer dias = 10;
        i.setDia(Byte.parseByte(dias.toString()));
        return i;
    }

    private TSTpAcConv createTpAcordo(String codigo) {
        return TSTpAcConv.valueOf(codigo);
    }

    private TSSimNao createSimNao() {
        return TSSimNao.N;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur getInfoPeriodoApuracao(MovimentoFolha mov, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev.InfoPerApur infoPeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerApur();
        infoPeriodo.getIdeEstabLot().add(this.getEstLot(mov, opcoes));
        return infoPeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot getEstLot(MovimentoFolha movimentoFolha, OpcoesESocial opcoes) throws ExceptionEsocial {
        if (movimentoFolha.getLotacaoTributaria() == null) {
            throw new ExceptionEsocial("Folha do Colaborador: " + movimentoFolha.getColaborador().toString() + " sem Lota\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo Informada");
        }
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot id = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLot();
        if (movimentoFolha.getEstabelecimento().getInformarDadosCAEPF().equals((short)0)) {
            id.setTpInsc(Byte.parseByte("1"));
            id.setNrInsc(ToolString.refina((String)movimentoFolha.getEmpresa().getPessoa().getComplemento().getCnpj()));
        } else {
            if (movimentoFolha.getEstabelecimento().getCaepf() != null && movimentoFolha.getEstabelecimento().getCaepf().getCodigo().equals("4")) {
                id.setTpInsc(Byte.parseByte("4"));
            } else {
                id.setTpInsc(Byte.parseByte("3"));
            }
            id.setNrInsc(ToolString.refina((String)movimentoFolha.getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCodCei()));
        }
        id.setCodLotacao(movimentoFolha.getColaborador().getLotacaoTributaria().getCodigo());
        id.getRemunPerApur().add(this.getRemuneracaoPeriodo(movimentoFolha, opcoes));
        return id;
    }
}

