/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.infoempregador;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfoempregador.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfoempregador.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfoempregador.v_s_01_03_00.TIdeEventoExclusao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfoempregador.v_s_01_03_00.TIdePeriodo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtinfoempregador.v_s_01_03_00.TInfoCadastro;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigInteger;
import java.util.Date;

public class ImplInfoEmpregador
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento evento, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        return this.getRootEvento(evento.getPreEvento(), opcoesEsocial);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        OpcoesESocial opcoes = opcoesEsocial;
        ESocial root = this.getFact().createESocial();
        root.setEvtInfoEmpregador(this.getInfoEmpregador(opcoes, preEvento));
        return root;
    }

    private ESocial.EvtInfoEmpregador getInfoEmpregador(OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtInfoEmpregador infoEmpregador = this.getFact().createESocialEvtInfoEmpregador();
        infoEmpregador.setIdeEvento(this.getIdeEvento(preEvento.getEsocEvento(), opcoes));
        infoEmpregador.setIdeEmpregador(this.getIdeEmpregador(opcoes));
        infoEmpregador.setInfoEmpregador(this.getDadosEvento(opcoes, preEvento));
        infoEmpregador.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        infoEmpregador.setIdeEvento(this.getIdeEvento(preEvento.getEsocEvento(), opcoes));
        return infoEmpregador;
    }

    private ESocial.EvtInfoEmpregador.InfoEmpregador getDadosEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        ESocial.EvtInfoEmpregador.InfoEmpregador evento = this.getFact().createESocialEvtInfoEmpregadorInfoEmpregador();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            evento.setInclusao(this.getInclusao(opcoes, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            evento.setAlteracao(this.getAlteracao(opcoes, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            evento.setExclusao(this.getExclusao(preEvento));
        }
        return evento;
    }

    private String getSimOrNao(Short multiplasTabelasRubricas) {
        if (multiplasTabelasRubricas.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    private BigInteger formatarBigInteger(String campo) {
        BigInteger numero = new BigInteger(campo);
        return numero;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtInfoEmpregador.InfoEmpregador.Inclusao getInclusao(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        ESocial.EvtInfoEmpregador.InfoEmpregador.Inclusao inclusao = this.getFact().createESocialEvtInfoEmpregadorInfoEmpregadorInclusao();
        inclusao.setIdePeriodo(this.getPeriodo(preEvento.getDataInicioVal(), preEvento.getDataFimVal()));
        inclusao.setInfoCadastro(this.getInfoCadastro(opcoes));
        return inclusao;
    }

    private ESocial.EvtInfoEmpregador.InfoEmpregador.Alteracao getAlteracao(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        ESocial.EvtInfoEmpregador.InfoEmpregador.Alteracao alteracao = this.getFact().createESocialEvtInfoEmpregadorInfoEmpregadorAlteracao();
        alteracao.setIdePeriodo(this.getPeriodo(preEvento.getEventoAnterior().getDataInicioVal(), preEvento.getEventoAnterior().getDataFimVal()));
        alteracao.setInfoCadastro(this.getInfoCadastro(opcoes));
        alteracao.setNovaValidade(this.getTNovaValidade(preEvento));
        return alteracao;
    }

    private ESocial.EvtInfoEmpregador.InfoEmpregador.Exclusao getExclusao(EsocPreEvento preEvento) {
        ESocial.EvtInfoEmpregador.InfoEmpregador.Exclusao exclusao = this.getFact().createESocialEvtInfoEmpregadorInfoEmpregadorExclusao();
        exclusao.setIdePeriodo(this.getPeriodo(preEvento.getDataInicioVal(), preEvento.getDataFimVal()));
        return exclusao;
    }

    private TIdePeriodo getPeriodo(Date dataIn, Date dataFim) {
        TIdePeriodo periodo = this.getFact().createTIdePeriodo();
        periodo.setIniValid(ToolDate.formatDateAnoMes((Date)dataIn));
        if (dataFim != null) {
            periodo.setFimValid(ToolDate.formatDateAnoMes((Date)dataFim));
        }
        return periodo;
    }

    private TIdePeriodo getTNovaValidade(EsocPreEvento preEvento) {
        TIdePeriodo validade = this.getFact().createTIdePeriodo();
        validade.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            validade.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return validade;
    }

    private TInfoCadastro getInfoCadastro(OpcoesESocial opcoes) {
        TInfoCadastro infoEmpregador = this.getFact().createTInfoCadastro();
        infoEmpregador.setClassTrib(opcoes.getClassificacaoTributaria().getCodigo());
        if (!opcoes.getClassificacaoTributaria().getCodigo().equals("21")) {
            infoEmpregador.setIndConstr(Byte.valueOf(opcoes.getIndicativoConstrutora().getCodigo()));
            infoEmpregador.setIndCoop(Byte.valueOf(opcoes.getIndicativoCooperativa().getCodigo()));
        }
        infoEmpregador.setIndDesFolha(opcoes.getIndicativoDesoneracaoFolha().byteValue());
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("07") || opcoes.getClassificacaoTributaria().getCodigo().equals("21")) {
            if (opcoes.getIndOpcCP().equals((short)1)) {
                infoEmpregador.setIndOpcCP(Byte.valueOf("2"));
            } else {
                infoEmpregador.setIndOpcCP(Byte.valueOf("1"));
            }
        }
        infoEmpregador.setIndOptRegEletron(opcoes.getOpcaoRegistroEletronicoTrab().byteValue());
        if (opcoes.getTributaPisFolha().equals((short)1)) {
            infoEmpregador.setIndTribFolhaPisPasep("S");
        }
        return infoEmpregador;
    }

    private TIdeEventoExclusao getIdeEvento(EsocEvento evt, OpcoesESocial opcoes) {
        TIdeEventoExclusao cadastro = this.getFact().createTIdeEventoExclusao();
        cadastro.setTpAmb(Byte.parseByte(evt.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private ESocial.EvtInfoEmpregador.IdeEmpregador getIdeEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtInfoEmpregador.IdeEmpregador empregador = this.getFact().createESocialEvtInfoEmpregadorIdeEmpregador();
        empregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        empregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return empregador;
    }
}

