/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.comprovanteentrega;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFDetCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFEnvCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFInfCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigNFeCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.model.env.comprovanteentrega.NFeCancelamentoComprovanteEntrega;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UtilCancelamentoComprovanteEntregaNFe {
    public NFRetornoEvtComprovanteEntrega enviarComprovanteEntrega(ParamsCertificado paramsCertificado, EnumConstNFeVersao versao, NFeCancelamentoComprovanteEntrega comp) throws Exception {
        CertificadoConfigNFeCTe nfc = new CertificadoConfigNFeCTe(paramsCertificado, comp.getCodigoUf());
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(paramsCertificado.getKeystoreCertificado(), paramsCertificado.getSenhaCertificado());
        return new WSFacade((NFeConfig)nfc).cancelarComprovanteEntregaNFe(comp.getChaveNFe(), this.getComprovanteToSend(comp), comp.getNumSeqEvento().intValue());
    }

    private NFEnvCancelamentoComprovanteEntrega getComprovanteToSend(NFeCancelamentoComprovanteEntrega comprovante) throws Exception {
        NFEnvCancelamentoComprovanteEntrega toSend = new NFEnvCancelamentoComprovanteEntrega();
        NFInfCancelamentoComprovanteEntrega evt = new NFInfCancelamentoComprovanteEntrega();
        evt.setChaveAcessoNFe(comprovante.getChaveNFe());
        if (TMethods.isNotNull((Object)comprovante.getCpfCnpj()).booleanValue()) {
            if (TMethods.isEquals((Object)comprovante.getCpfCnpj().length(), (Object)14)) {
                evt.setCnpj(comprovante.getCpfCnpj());
            } else {
                evt.setCpf(comprovante.getCpfCnpj());
            }
        }
        evt.setDataEvento(ToolDate.dateToZonedDateTime((Date)comprovante.getDataEvento()));
        evt.setNumSeqEvento(comprovante.getNumSeqEvento());
        NFDetCancelamentoComprovanteEntrega det = new NFDetCancelamentoComprovanteEntrega();
        det.setDescricao("Cancelamento Comprovante de Entrega da NF-e");
        det.setAutor(DFUnidadeFederativa.valueOfCodigo((String)comprovante.getCodigoUf()));
        det.setVersaoAplicacao(comprovante.getVersaoAplicacao());
        det.setNumeroProtocolo(comprovante.getNumeroProtocoloEvt());
        det.setTipoAutor(Integer.valueOf(1));
        evt.setDetalhesEvento(det);
        NFCancelamentoComprovanteEntrega evento = new NFCancelamentoComprovanteEntrega();
        evento.setInfEvento(evt);
        toSend.setEvento(new ArrayList<NFCancelamentoComprovanteEntrega>(List.of(evento)));
        return toSend;
    }
}

