/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.comprovanteentrega;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFDetComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFEnvComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFInfComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigNFeCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.model.env.comprovanteentrega.NFeComprovanteEntrega;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;

public class UtilEnvioComprovanteEntregaNFe {
    public NFRetornoEvtComprovanteEntrega enviarComprovanteEntrega(ParamsCertificado paramsCertificado, EnumConstNFeVersao versao, NFeComprovanteEntrega comp) throws Exception {
        CertificadoConfigNFeCTe nfc = new CertificadoConfigNFeCTe(paramsCertificado, comp.getCodigoUf());
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(paramsCertificado.getKeystoreCertificado(), paramsCertificado.getSenhaCertificado());
        return new WSFacade((NFeConfig)nfc).enviaComprovanteEntregaNFe(comp.getChaveAcesso(), this.getComprovanteToSend(comp), comp.getNumSeqEvento().intValue());
    }

    private NFEnvComprovanteEntrega getComprovanteToSend(NFeComprovanteEntrega comprovante) throws Exception {
        NFEnvComprovanteEntrega toSend = new NFEnvComprovanteEntrega();
        NFInfComprovanteEntrega evt = new NFInfComprovanteEntrega();
        if (TMethods.isStrWithData((String)comprovante.getChaveAcesso())) {
            evt.setChaveAcessoNFe(comprovante.getChaveAcesso());
        }
        if (TMethods.isNotNull((Object)comprovante.getCpfCnpj()).booleanValue()) {
            if (TMethods.isEquals((Object)comprovante.getCpfCnpj().length(), (Object)14)) {
                evt.setCnpj(comprovante.getCpfCnpj());
            } else {
                evt.setCpf(comprovante.getCpfCnpj());
            }
        }
        evt.setDataEvento(ToolDate.dateToZonedDateTime((Date)comprovante.getDataEvento()));
        evt.setNumSeqEvento(comprovante.getNumSeqEvento());
        NFDetComprovanteEntrega det = new NFDetComprovanteEntrega();
        det.setComprovante(UtilEnvioComprovanteEntregaNFe.gerarHashComprovante(comprovante.getComprovante()));
        det.setDataEntrega(ToolDate.dateToZonedDateTime((Date)comprovante.getDataEntrega()));
        det.setDataComprovante(ToolDate.dateToZonedDateTime((Date)comprovante.getDataEntrega()));
        det.setDescricao("Comprovante de Entrega da NF-e");
        det.setDocumentoRecebedor(comprovante.getDocumentoRecebedor());
        det.setNomeRecebedor(comprovante.getNomeRecebedor());
        det.setAutor(DFUnidadeFederativa.valueOfCodigo((String)comprovante.getCodigoUf()));
        det.setVersaoAplicacao(comprovante.getVersaoAplicacao());
        det.setTipoAutor(Integer.valueOf(1));
        evt.setDetalhesEvento(det);
        NFComprovanteEntrega evento = new NFComprovanteEntrega();
        evento.setInfEvento(evt);
        toSend.setEvento(new ArrayList<NFComprovanteEntrega>(List.of(evento)));
        return toSend;
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String gerarHashComprovante(String hexString) throws NoSuchAlgorithmException {
        byte[] imageBytes = UtilEnvioComprovanteEntregaNFe.hexStringToByteArray(hexString);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] hashBytes = digest.digest(imageBytes);
        return Base64.getEncoder().encodeToString(hashBytes);
    }
}

