/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfse.impl.envialote;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorclientwebservices.nfse.model.env.NFSeRps;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.brazilutils.br.cpfcnpj.CpfCnpj;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuxBuilderRpsEnv {
    private NFSeRps toNFSeRps(Rps rps, OpcoesFaturamentoNFSe opFatNFse) {
        NFSeRps nfse = new NFSeRps();
        nfse.setIdentificador(rps.getIdentificador());
        nfse.setDataEmissao(rps.getDataEmissao());
        nfse.setNaturezaOperacao(rps.getNaturezaOperacaoRps().getCodigo());
        if (rps.getRegimeEspTributacao() != null) {
            nfse.setRegimeEspecialTributacao(rps.getRegimeEspTributacao().getCodigo());
        }
        if (ToolMethods.isEquals((Object)rps.getEmpresa().getEmpresaDados().getRegimeTributario().getCodigo(), (Object)1) || ToolMethods.isEquals((Object)rps.getEmpresa().getEmpresaDados().getRegimeTributario().getCodigo(), (Object)2)) {
            nfse.setOptanteSimplesNacional(EnumConstantsMentorSimNao.SIM.getValue());
        } else {
            nfse.setOptanteSimplesNacional(EnumConstantsMentorSimNao.NAO.getValue());
        }
        nfse.setIncentivadorCultural(EnumConstantsMentorSimNao.NAO.getValue());
        nfse.setCodigoObra(rps.getCodigoObra());
        nfse.setArt(rps.getArtObra());
        if (TMethods.isNotNull((Object)rps.getRpsSubstituto()).booleanValue()) {
            nfse.setNumeroRpsSubstituido(String.valueOf(rps.getRpsSubstituto().getNumero()));
            nfse.setSerieRpsSubstituido(String.valueOf(rps.getRpsSubstituto().getSerie()));
            nfse.setTipoRpsSubstituido(rps.getRpsSubstituto().getTipoRps().getCodigo());
        }
        NFSeRps.NFSeRpsPrestador prestador = new NFSeRps.NFSeRpsPrestador();
        prestador.setCnpj(ToolString.refina((String)rps.getEmpresa().getPessoa().getComplemento().getCnpj()));
        prestador.setCodigoMunicipio(rps.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbgeCompleto());
        prestador.setInscricaoMunicipal(ToolString.refina((String)rps.getEmpresa().getPessoa().getComplemento().getInscricaoMunicipal()));
        nfse.setPrestador(prestador);
        NFSeRps.NFSeRpsTomador tomador = new NFSeRps.NFSeRpsTomador();
        CpfCnpj cpfCnpj = new CpfCnpj(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.isCnpj()) {
            tomador.setCnpj(ToolString.refina((String)rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getComplemento().getCnpj()));
        } else {
            tomador.setCpf(ToolString.refina((String)rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getComplemento().getCnpj()));
        }
        tomador.setInscricaoMunicipal(ToolString.refina((String)rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getComplemento().getInscricaoMunicipal()));
        tomador.setRazaoSocial(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome());
        tomador.setTelefone(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getComplemento().getFone1());
        tomador.setEmail(rps.getEmail());
        NFSeRps.NFSeRpsEnderecoPessoa enderecoTomador = new NFSeRps.NFSeRpsEnderecoPessoa();
        enderecoTomador.setBairro(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getBairro());
        enderecoTomador.setLogradouro(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getLogradouro());
        enderecoTomador.setNumero(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getNumero());
        enderecoTomador.setComplemento(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getComplemento());
        enderecoTomador.setCodigoMunicipio(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getCidade().getCodIbgeCompleto());
        enderecoTomador.setUf(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getCidade().getUf().getSigla());
        enderecoTomador.setCep(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getEndereco().getCep());
        tomador.setEndereco(enderecoTomador);
        nfse.setTomador(tomador);
        NFSeRps.NFSeRpsServico servico = new NFSeRps.NFSeRpsServico();
        servico.setValorServicos(rps.getValorServico());
        servico.setValorDeducoes(rps.getValorDeducoes());
        servico.setValorPis(rps.getValorPisST());
        servico.setValorCofins(rps.getValorCofinsST());
        servico.setValorInss(rps.getValorInss());
        servico.setValorIr(rps.getValorIr());
        servico.setValorCsll(rps.getValorContSoc());
        servico.setIssRetido(rps.getTipoIss());
        servico.setValorIss(rps.getValorIss());
        servico.setValorIssRetido(rps.getValorIssRetido());
        servico.setOutrasRetencoes(rps.getValorOutros());
        servico.setBaseCalculo(rps.getBcIss());
        servico.setAliquota(rps.getAliquotaIss());
        servico.setDescontoCondicionado(rps.getValorDescontoCondicionado());
        servico.setDescontoIncondicionado(rps.getValorDescontoIncondicionado());
        if (ToolMethods.isAffirmative((Number)opFatNFse.getInformarDadosItemServico())) {
            ArrayList<NFSeRps.NFSeRpsListaItensServico> lista = new ArrayList<NFSeRps.NFSeRpsListaItensServico>();
            for (ItemServicoRPSRPS it : rps.getItensRps()) {
                NFSeRps.NFSeRpsListaItensServico i = new NFSeRps.NFSeRpsListaItensServico();
                i.setItemListaServico(rps.getServicoRPS().getGrupoServicoRPS().getCodigoServico());
                i.setCodigoCnae(rps.getCnae().getCodigo());
                i.setDiscriminacao(it.getItemServicoRPS().getDescricao());
                i.setValorUnitario(it.getValor());
                i.setQuantidade(1.0);
                i.setValorLiquido(it.getValor());
                lista.add(i);
            }
            servico.setListaItensServico(lista);
        } else {
            servico.setItemListaServico(rps.getServicoRPS().getGrupoServicoRPS().getCodigoServico());
            servico.setCodigoCnae(rps.getCnae().getCodigo());
        }
        servico.setCodigoTributarioMunicipio(rps.getCodigoTributacaoServ());
        Object discriminacao = "";
        if (TMethods.isStrWithData((String)rps.getDiscriminacao())) {
            discriminacao = (String)discriminacao + rps.getDiscriminacao();
        }
        servico.setDiscriminacao((String)discriminacao);
        servico.setCodigoMunicipio(rps.getCidade().getCodIbgeCompleto());
        servico.setInformacoesAdicionaisContribuinte(rps.getObservacao());
        nfse.setServico(servico);
        return nfse;
    }

    public String toJson(Rps rpsParam, OpcoesFaturamentoNFSe opFatNFSe) {
        HashMap<String, String> nfse = new HashMap<String, String>();
        HashMap<String, String> prestador = new HashMap<String, String>();
        HashMap<String, String> tomador = new HashMap<String, String>();
        HashMap<String, String> tomadorEndereco = new HashMap<String, String>();
        HashMap<String, String> servico = new HashMap<String, String>();
        HashMap<String, String> intermediador = null;
        NFSeRps rps = this.toNFSeRps(rpsParam, opFatNFSe);
        nfse.put("data_emissao", ToolDate.dateToStr((Date)rps.getDataEmissao(), (String)"yyyy-MM-dd'T'HH:mm:ss"));
        nfse.put("natureza_operacao", rps.getNaturezaOperacao());
        nfse.put("regime_especial_tributacao", rps.getRegimeEspecialTributacao());
        nfse.put("optante_simples_nacional", String.valueOf(TMethods.isAffirmative((Number)rps.getOptanteSimplesNacional())));
        nfse.put("incentivador_cultural", String.valueOf(TMethods.isAffirmative((Number)rps.getIncentivadorCultural())));
        nfse.put("codigo_obra", this.strOrNull(rps.getCodigoObra()));
        nfse.put("art", this.strOrNull(rps.getArt()));
        nfse.put("numero_rps_substituido", this.strOrNull(rps.getNumeroRpsSubstituido()));
        nfse.put("serie_rps_substituido", this.strOrNull(rps.getSerieRpsSubstituido()));
        nfse.put("tipo_rps_substituido", this.strOrNull(rps.getTipoRpsSubstituido()));
        if (TMethods.isNotNull((Object)rps.getPrestador()).booleanValue()) {
            prestador.put("cnpj", ToolString.refina((String)rps.getPrestador().getCnpj()));
            prestador.put("inscricao_municipal", this.strOrNull(rps.getPrestador().getInscricaoMunicipal()));
            prestador.put("codigo_municipio", this.strOrNull(rps.getPrestador().getCodigoMunicipio()));
        }
        if (TMethods.isNotNull((Object)rps.getTomador()).booleanValue()) {
            tomador.put("cpf", ToolString.refina((String)rps.getTomador().getCpf()));
            tomador.put("cnpj", ToolString.refina((String)rps.getTomador().getCnpj()));
            tomador.put("inscricao_municipal", this.strOrNull(rps.getTomador().getInscricaoMunicipal()));
            tomador.put("razao_social", this.strOrNull(rps.getTomador().getRazaoSocial()));
            tomador.put("telefone", this.strOrNull(rps.getTomador().getTelefone()));
            tomador.put("email", this.strOrNull(rps.getTomador().getEmail()));
            if (TMethods.isNotNull((Object)rps.getTomador().getEndereco()).booleanValue()) {
                tomadorEndereco.put("bairro", this.strOrNull(rps.getTomador().getEndereco().getBairro()));
                tomadorEndereco.put("tipo_logradouro", this.strOrNull(rps.getTomador().getEndereco().getTipoLogradouro()));
                tomadorEndereco.put("complemento", this.strOrNull(rps.getTomador().getEndereco().getComplemento()));
                tomadorEndereco.put("cep", this.strOrNull(rps.getTomador().getEndereco().getCep()));
                tomadorEndereco.put("codigo_municipio", this.strOrNull(rps.getTomador().getEndereco().getCodigoMunicipio()));
                tomadorEndereco.put("logradouro", this.strOrNull(rps.getTomador().getEndereco().getLogradouro()));
                tomadorEndereco.put("numero", this.strOrNull(rps.getTomador().getEndereco().getNumero()));
                tomadorEndereco.put("uf", this.strOrNull(rps.getTomador().getEndereco().getUf()));
            }
        }
        if (TMethods.isNotNull((Object)rps.getServico()).booleanValue()) {
            servico.put("valor_servicos", String.valueOf(this.arredondar(rps.getServico().getValorServicos())));
            servico.put("valor_deducoes", String.valueOf(this.arredondar(rps.getServico().getValorDeducoes())));
            servico.put("valor_pis", String.valueOf(this.arredondar(rps.getServico().getValorPis())));
            servico.put("valor_cofins", String.valueOf(this.arredondar(rps.getServico().getValorCofins())));
            servico.put("valor_inss", String.valueOf(this.arredondar(rps.getServico().getValorInss())));
            servico.put("valor_ir", String.valueOf(this.arredondar(rps.getServico().getValorIr())));
            servico.put("valor_csll", String.valueOf(this.arredondar(rps.getServico().getValorCsll())));
            servico.put("iss_retido", String.valueOf(TMethods.isEquals((Object)rps.getServico().getIssRetido(), (Object)EnumConstantsMentorSimNao.SIM.getValue())));
            servico.put("valor_iss", String.valueOf(this.arredondar(rps.getServico().getValorIss())));
            servico.put("valor_iss_retido", String.valueOf(this.arredondar(rps.getServico().getValorIssRetido())));
            servico.put("outras_retencoes", String.valueOf(this.arredondar(rps.getServico().getOutrasRetencoes())));
            servico.put("base_calculo", String.valueOf(this.arredondar(rps.getServico().getBaseCalculo())));
            servico.put("aliquota", String.valueOf(this.arredondar(rps.getServico().getAliquota())));
            servico.put("desconto_incondicionado", String.valueOf(this.arredondar(rps.getServico().getDescontoIncondicionado())));
            servico.put("desconto_condicionado", String.valueOf(this.arredondar(rps.getServico().getDescontoCondicionado())));
            if (!ToolMethods.isAffirmative((Number)opFatNFSe.getInformarDadosItemServico())) {
                servico.put("item_lista_servico", ToolString.refina((String)rps.getServico().getItemListaServico()));
                servico.put("codigo_cnae", this.strOrNull(rps.getServico().getCodigoCnae()));
            }
            servico.put("codigo_tributario_municipio", this.strOrNull(rps.getServico().getCodigoTributarioMunicipio()));
            servico.put("discriminacao", this.strOrNull(rps.getServico().getDiscriminacao()));
            servico.put("codigo_municipio", this.strOrNull(rps.getServico().getCodigoMunicipio()));
            servico.put("percentual_total_tributos", String.valueOf(rps.getServico().getPercentualTotalTributos()));
            servico.put("fonte_total_tributos", this.strOrNull(rps.getServico().getFonteTotalTributos()));
            servico.put("informacoes_adicionais_contribuinte", this.strOrNull(rps.getServico().getInformacoesAdicionaisContribuinte()));
            if (ToolMethods.isAffirmative((Number)opFatNFSe.getInformarDadosItemServico())) {
                JSONArray listaItensServico = new JSONArray();
                for (NFSeRps.NFSeRpsListaItensServico item : rps.getServico().getListaItensServico()) {
                    JSONObject item1 = new JSONObject();
                    item1.put("item_lista_servico", (Object)this.strOrNull(item.getItemListaServico()));
                    item1.put("codigo_cnae", (Object)this.strOrNull(item.getCodigoCnae()));
                    item1.put("discriminacao", (Object)this.strOrNull(item.getDiscriminacao()));
                    item1.put("quantidade", (Object)String.valueOf(this.arredondar(item.getQuantidade())));
                    item1.put("valor_unitario", (Object)String.valueOf(this.arredondar(item.getValorUnitario())));
                    item1.put("valor_liquido", (Object)String.valueOf(this.arredondar(item.getValorLiquido())));
                    listaItensServico.put((Object)item1);
                }
                servico.put("lista_itens_servico", (String)listaItensServico);
            }
        }
        if (TMethods.isNotNull((Object)rps.getIntermediario()).booleanValue()) {
            intermediador = new HashMap<String, String>();
            intermediador.put("razao_social", this.strOrNull(rps.getIntermediario().getRazaoSocial()));
            intermediador.put("cpf", ToolString.refina((String)rps.getIntermediario().getCpf()));
            intermediador.put("cnpj", ToolString.refina((String)rps.getIntermediario().getCnpj()));
            intermediador.put("inscricao_municipal", this.strOrNull(rps.getIntermediario().getInscricaoMunicipal()));
        }
        JSONObject json = new JSONObject(nfse);
        JSONObject jsonPrestador = new JSONObject(prestador);
        json.accumulate("prestador", (Object)jsonPrestador);
        JSONObject jsonTomador = new JSONObject(tomador);
        json.accumulate("tomador", (Object)jsonTomador);
        JSONObject jsonTomadorEndereco = new JSONObject(tomadorEndereco);
        jsonTomador.accumulate("endereco", (Object)jsonTomadorEndereco);
        JSONObject jsonServico = new JSONObject(servico);
        json.accumulate("servico", (Object)jsonServico);
        if (TMethods.isNotNull(intermediador).booleanValue()) {
            JSONObject jsonIntermediario = new JSONObject(intermediador);
            json.accumulate("intermediario", (Object)jsonIntermediario);
        }
        return json.toString();
    }

    private String strOrNull(String str) {
        if (TMethods.isStrWithData((String)str)) {
            return str;
        }
        return null;
    }

    private Double arredondar(Double numero) {
        return ToolFormatter.arrredondarNumero((Double)numero, (int)2, (int)RoundingMode.HALF_EVEN.ordinal());
    }
}

