/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfse.impl.envialote;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.constants.enums.opcoesfaturamentonfse.EnumConstTipoAmbienteNFSe;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorclientwebservices.nfse.constants.ConstStatusApiNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.BaseCommunicantionNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.envialote.AuxBuilderRpsEnv;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultEnv;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.EnumExcepEnviaNFSe;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.ExceptionEnviaNFSe;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient2;
import java.text.MessageFormat;

public class UtilEnviaNFSe
extends BaseCommunicantionNFSe<NFSeResultEnv> {
    public NFSeResultEnv send(ConfigServicosTerceiros configServ, OpcoesFaturamentoNFSe opFatNFSe, Rps rps) throws ExceptionBase {
        String json = new AuxBuilderRpsEnv().toJson(rps, opFatNFSe);
        ToolRESTWebServiceClient2.Config config = new ToolRESTWebServiceClient2.Config();
        String token = "";
        String url = "";
        if (ToolMethods.isEquals((Object)opFatNFSe.getTipoAmbiente(), (Object)EnumConstTipoAmbienteNFSe.IDENT_AMBIENTE_PRODUCAO_NFSE.getValue())) {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_ENVIO_NFSE.getChave());
        } else {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN_HOMOLOGACAO.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_ENVIO_NFSE_HOMOLOGACAO.getChave());
        }
        config.setUrl(MessageFormat.format(url, String.valueOf(rps)));
        config.getRequestProperties().put("Authorization", "Basic " + ToolBase64.encodeBase64((String)token));
        config.getRequestProperties().put("User-Agent", "Mozilla/4.76");
        config.getRequestProperties().put("Accept", "application/json");
        config.setMethod(ToolRESTWebServiceClient2.Method.POST);
        config.setStatusCode(this.statusHttpApi());
        config.setBody(json);
        NFSeResultEnv result = this.request(config, new TypeReference<NFSeResultEnv>(this){});
        return result;
    }

    @Override
    protected Boolean validResult(NFSeResultEnv result) throws ExceptionEnviaNFSe {
        if (UtilEnviaNFSe.isNull((Object)result).booleanValue()) {
            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.RESPOSTA_RECEBIDA_NULA, new Object[0]);
        }
        ConstStatusApiNFSe status = ConstStatusApiNFSe.get(result.getStatus());
        if (!UtilEnviaNFSe.isEquals((Object)((Object)status), (Object)((Object)ConstStatusApiNFSe.PROCESSANDO_AUTORIZACAO))) {
            if (UtilEnviaNFSe.isStrWithData((String)result.getCodigo())) {
                status = ConstStatusApiNFSe.get(result.getCodigo());
                if (!UtilEnviaNFSe.isEquals((Object)((Object)status), (Object)((Object)ConstStatusApiNFSe.EM_PROCESSAMENTO))) {
                    switch (status) {
                        case NAO_ENCONTRADO: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_NAO_ENCONTRADA, new Object[]{result.getMensagem()});
                        }
                        case NFE_CANCELADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_CANCELADA, new Object[]{result.getMensagem()});
                        }
                        case NFE_NAO_AUTORIZADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_NAO_AUTORIZADA, new Object[]{result.getMensagem()});
                        }
                        case EMPRESA_NAO_HABILITADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.EMPRESA_NAO_HABILITADA, new Object[]{result.getMensagem()});
                        }
                        case CERITIFICADO_VENCIDO: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.CERTIFICADO_VENCIDO, new Object[]{result.getMensagem()});
                        }
                        case ERRO_VALIDACAO_SCHEMA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.VALIDACAO_SCHEMA_XML, new Object[]{result.getMensagem()});
                        }
                        case PERMISSAO_NEGADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.PERMISSAO_NEGADA, new Object[]{result.getMensagem()});
                        }
                    }
                    throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.REQUISICAO_INVALIDA, new Object[]{result.getMensagem()});
                }
            } else {
                throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.REQUISICAO_INVALIDA, new Object[]{result.getMensagem()});
            }
        }
        return true;
    }
}

