/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication.departamento;

import com.touchcomp.basementorclientwebservices.ponto.communication.PontoBaseCommunication;
import com.touchcomp.basementorclientwebservices.ponto.communication.departamento.WebServicePontoDepartamento;
import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.result.tangerino.DTOResultDepartamentoTangerino;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.result.tangerino.DTOResultListDepartamentosTangerino;
import com.touchcomp.basementorclientwebservices.ponto.transformer.impl.TangerinoTransform;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class WebServicePontoDepartamentoTangerino
extends PontoBaseCommunication
implements WebServicePontoDepartamento<DTOResultDepartamentoTangerino, DTOResultListDepartamentosTangerino> {
    @Override
    public void register(DTOPontoDepartamento dto) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        if (WebServicePontoDepartamentoTangerino.isNotNull((Object)dto).booleanValue()) {
            TangerinoTransform builder = (TangerinoTransform)this.getBuilder(EnumConstSistemaPonto.TANGERINO);
            this.sendPost(builder.departamento(dto), "https://employer.tangerino.com.br/workplace/register?allowUpdate=false");
        }
    }

    @Override
    public DTOResultListDepartamentosTangerino listAll() throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        String result = this.sendGet("https://employer.tangerino.com.br/workplace/find-all");
        return (DTOResultListDepartamentosTangerino)this.readJson(result, DTOResultListDepartamentosTangerino.class);
    }

    @Override
    public DTOResultDepartamentoTangerino list(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("externalId", String.valueOf(id)));
        String result = this.sendGet("https://employer.tangerino.com.br/workplace/find", params);
        return (DTOResultDepartamentoTangerino)this.readJson(result, DTOResultDepartamentoTangerino.class);
    }

    @Override
    public void delete(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("externalId", String.valueOf(id)));
        String result = this.sendDelete("https://employer.tangerino.com.br/workplace/delete", params);
    }
}

