/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtexclusao;

import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtexclusao.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtexclusao.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;

public class ImplExclusao
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        R1000 opcoes = opcoesReinf;
        Reinf root = this.getFact().createReinf();
        root.setEvtExclusao(this.getEvtFechaPer(opcoes, preEvento));
        return root;
    }

    private Reinf.EvtExclusao getEvtFechaPer(R1000 opcoes, ReinfPreEvento preEvento) throws ExceptionReinf {
        Reinf.EvtExclusao infExclusao = this.getFact().createReinfEvtExclusao();
        infExclusao.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        infExclusao.setIdeContri(this.getIdeContribuinte(opcoes));
        infExclusao.setInfoExclusao(this.getInfoExclusao(preEvento));
        infExclusao.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        return infExclusao;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtExclusao.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtExclusao.IdeEvento cadastro = this.getFact().createReinfEvtExclusaoIdeEvento();
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtExclusao.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtExclusao.IdeContri empregador = this.getFact().createReinfEvtExclusaoIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtExclusao.InfoExclusao getInfoExclusao(ReinfPreEvento preEvento) {
        Reinf.EvtExclusao.InfoExclusao inf = this.getFact().createReinfEvtExclusaoInfoExclusao();
        ReinfPreEvento eventoAnterior = preEvento.getEventoAnterior();
        inf.setNrRecEvt(eventoAnterior.getReinfEvento().getNrRecibo());
        inf.setTpEvento(eventoAnterior.getTipoEventoReinf().getCodigo());
        if (eventoAnterior.getItemReinf2010() != null) {
            inf.setPerApur(ToolDate.formatDateAnoMes((Date)eventoAnterior.getItemReinf2010().getApuracaoReinf().getPeriodo()));
        } else if (eventoAnterior.getItemReinf2020() != null) {
            inf.setPerApur(ToolDate.formatDateAnoMes((Date)eventoAnterior.getItemReinf2020().getApuracaoReinf().getPeriodo()));
        } else if (eventoAnterior.getR2060() != null) {
            inf.setPerApur(ToolDate.formatDateAnoMes((Date)eventoAnterior.getR2060().getPeriodo()));
        }
        return inf;
    }
}

