/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtfechamento;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfR2099;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtfechamento.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtfechamento.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImplFechamento
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        R1000 opcoes = opcoesReinf;
        Reinf root = this.getFact().createReinf();
        root.setEvtFechaEvPer(this.getEvtFechaPer(opcoes, preEvento));
        return root;
    }

    private Reinf.EvtFechaEvPer getEvtFechaPer(R1000 opcoes, ReinfPreEvento preEvento) throws ExceptionReinf {
        Reinf.EvtFechaEvPer infoFech = this.getFact().createReinfEvtFechaEvPer();
        infoFech.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        infoFech.setIdeContri(this.getIdeContribuinte(opcoes));
        infoFech.setIdeRespInf(this.getIdeRespInf(preEvento.getR2099().getPessoaRespInf()));
        infoFech.setInfoFech(this.getInfoFech(preEvento));
        infoFech.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        return infoFech;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtFechaEvPer.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtFechaEvPer.IdeEvento cadastro = this.getFact().createReinfEvtFechaEvPerIdeEvento();
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getR2099().getPeriodo()));
        return cadastro;
    }

    private Reinf.EvtFechaEvPer.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtFechaEvPer.IdeContri empregador = this.getFact().createReinfEvtFechaEvPerIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtFechaEvPer.IdeRespInf getIdeRespInf(Pessoa pessoa) {
        Reinf.EvtFechaEvPer.IdeRespInf respInf = this.getFact().createReinfEvtFechaEvPerIdeRespInf();
        respInf.setCpfResp(pessoa.getComplemento().getCnpj());
        respInf.setNmResp(ToolString.clearInvalidUTF8Char((String)pessoa.getNome()));
        if (pessoa.getComplemento().getFone1() != null && pessoa.getComplemento().getFone1().trim().length() > 0) {
            respInf.setTelefone(ToolString.preencheString((String)pessoa.getComplemento().getFone1(), (int)13, (String)"0", (boolean)true));
        }
        if (pessoa.getComplemento().getEmailPrincipal() != null && pessoa.getComplemento().getEmailPrincipal().trim().length() > 1) {
            respInf.setEmail(ToolString.clearInvalidUTF8Char((String)pessoa.getComplemento().getEmailPrincipal()));
        }
        return respInf;
    }

    private Reinf.EvtFechaEvPer.InfoFech getInfoFech(ReinfPreEvento preEvento) {
        ReinfR2099 r = preEvento.getR2099();
        Reinf.EvtFechaEvPer.InfoFech evento = this.getFact().createReinfEvtFechaEvPerInfoFech();
        evento.setEvtServPr(this.getSimOrNao(r.getEventoServicosPrestados()));
        evento.setEvtServTm(this.getSimOrNao(r.getEventoServicosTomados()));
        evento.setEvtCPRB(this.getSimOrNao(r.getEventoContribPrev()));
        evento.setEvtAssDespRec("N");
        evento.setEvtAssDespRep("N");
        evento.setEvtComProd(this.getSimOrNao(r.getEventosComercializacaoProdRural()));
        evento.setEvtAquis(this.getSimOrNao(r.getEventosAquisicaoProdRural()));
        return evento;
    }

    private String getSimOrNao(Short s) {
        if (s.equals((short)1)) {
            return "S";
        }
        return "N";
    }
}

