/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtpagamentorendimentojuridica;

import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4020;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4020pagtobeneficiariopj.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4020pagtobeneficiariopj.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Date;
import java.util.Iterator;

public class ImpEvt4020PagRendimentoJuridica
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtRetPJ(this.getEvtRetPJ(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtRetPJ getEvtRetPJ(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPJ evt = this.getFact().createReinfEvtRetPJ();
        evt.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        evt.setIdeContri(this.getIdeContribuinte(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        evt.setIdeEstab(this.getEstabelecimento(preEvento));
        return evt;
    }

    private Reinf.EvtRetPJ.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPJ.IdeContri empregador = this.getFact().createReinfEvtRetPJIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtRetPJ.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtRetPJ.IdeEvento cadastro = this.getFact().createReinfEvtRetPJIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinf4020().getApuracaoReinf().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtRetPJ.IdeEstab getEstabelecimento(ReinfPreEvento preEvento) {
        Reinf.EvtRetPJ.IdeEstab est = this.getFact().createReinfEvtRetPJIdeEstab();
        est.setTpInscEstab(Short.parseShort("1"));
        est.setNrInscEstab(preEvento.getItemReinf4020().getEmpresa().getPessoa().getComplemento().getCnpj());
        est.setIdeBenef(this.getIdentificadorBeneficario(preEvento));
        return est;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef getIdentificadorBeneficario(ReinfPreEvento preEvento) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef ideBen = this.getFact().createReinfEvtRetPJIdeEstabIdeBenef();
        ideBen.setCnpjBenef(preEvento.getItemReinf4020().getPessoa().getComplemento().getCnpj());
        for (ItemReinfNotas4020 itemNota : preEvento.getItemReinf4020().getItensNotas()) {
            Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto idePgto;
            boolean achou = false;
            Iterator<Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto> iterator = ideBen.getIdePgto().iterator();
            while (iterator.hasNext() && !(achou = this.existeNaturezaRendimento(idePgto = iterator.next(), itemNota))) {
            }
            if (achou) continue;
            ideBen.getIdePgto().add(this.getIdePagamento(itemNota));
        }
        return ideBen;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto getIdePagamento(ItemReinfNotas4020 itemNota) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto idePagamento = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgto();
        idePagamento.setNatRend(itemNota.getNaturezaRendimento().getCodigo());
        idePagamento.setObserv("OBSERVACAO");
        idePagamento.getInfoPgto().add(this.getInfoPagamento(itemNota));
        return idePagamento;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto getInfoPagamento(ItemReinfNotas4020 itemNota) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto info = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgtoInfoPgto();
        NotaFiscalTerceiros nfe = itemNota.getNotaTerceiros();
        Titulo titulo = this.getTitulo(nfe);
        if (itemNota.getValorIrrf() > 0.0 || itemNota.getValorCofins() == 0.0 && itemNota.getValorCsll() == 0.0 && itemNota.getValorPis() == 0.0 && itemNota.getValorAgregado() == 0.0) {
            info.setDtFG(ToolDate.formatDateAnoMesDia((Date)nfe.getDataEmissao()));
            info.setVlrBruto(this.getValor(nfe.getValoresNfTerceiros().getValorTotal()));
        } else {
            info.setDtFG(ToolDate.formatDateAnoMesDia((Date)titulo.getDataVencimento()));
            info.setVlrBruto(this.getValor(nfe.getValoresNfTerceiros().getValorTotal()));
        }
        info.setRetencoes(this.getRetencoes(itemNota));
        return info;
    }

    private Titulo getTitulo(NotaFiscalTerceiros nfe) {
        for (InfPagamentoNfTerceiros infPagamentoNfTerceiro : nfe.getInfPagamentoNfTerceiros()) {
            for (Titulo titulo : infPagamentoNfTerceiro.getTitulos()) {
                if (!titulo.getPessoa().equals((Object)nfe.getUnidadeFatFornecedor().getFornecedor().getPessoa())) continue;
                return titulo;
            }
        }
        return null;
    }

    private String getValor(Double valorTotal) {
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto.Retencoes getRetencoes(ItemReinfNotas4020 item) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto.Retencoes ret = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgtoInfoPgtoRetencoes();
        if (item.getValorIrrf() > 0.0) {
            ret.setVlrBaseIR(this.getValor(item.getBaseIrrf()));
            ret.setVlrIR(this.getValor(item.getValorIrrf()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorCsll() > 0.0) {
            ret.setVlrBaseCSLL(this.getValor(item.getBaseCsll()));
            ret.setVlrCSLL(this.getValor(item.getValorCsll()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorCofins() > 0.0) {
            ret.setVlrBaseCofins(this.getValor(item.getBaseCofins()));
            ret.setVlrCofins(this.getValor(item.getValorCofins()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorPis() > 0.0) {
            ret.setVlrBasePP(this.getValor(item.getBasePis()));
            ret.setVlrPP(this.getValor(item.getValorPis()));
        }
        if (item.getValorAgregado() > 0.0) {
            ret.setVlrBaseAgreg(this.getValor(item.getBaseAgregado()));
            ret.setVlrAgreg(this.getValor(item.getValorAgregado()));
        }
        return ret;
    }

    private boolean existeNaturezaRendimento(Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto idePgto, ItemReinfNotas4020 itemNota) {
        String cod = itemNota.getNaturezaRendimento().getCodigo();
        for (Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto infoPgto : idePgto.getInfoPgto()) {
            if (!idePgto.getNatRend().equals(cod)) continue;
            idePgto.getInfoPgto().add(this.getInfoPagamento(itemNota));
            return true;
        }
        return false;
    }
}

