/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.tools;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.EnumReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class ToolReinf {
    public static String getNrInscricaoEmpresa(Empresa empresa) throws ExceptionReinf {
        if (empresa.getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            return ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj().substring(0, 8));
        }
        if (empresa.getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId())) {
            return ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj());
        }
        throw new ExceptionReinf(EnumReinf.TIPO_INSCRICAO_NAO_MAPEADO, new Object[]{empresa});
    }

    public static String getNrInscricaoTransmissor(Empresa empresa) throws ExceptionReinf {
        if (empresa.getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            return ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj());
        }
        if (empresa.getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId())) {
            return ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj());
        }
        throw new ExceptionReinf(EnumReinf.TIPO_INSCRICAO_NAO_MAPEADO, new Object[]{empresa});
    }

    public static String getIdEvento(R1000 opcoesReinf, Date dataMovimentacao, Integer nrSeq) {
        String id = "ID";
        String numeroTpsInscricao = opcoesReinf.getEmpresa().getPessoa().getComplemento().getCnpj().substring(0, 8);
        numeroTpsInscricao = ToolString.completaZeros((String)numeroTpsInscricao, (int)14);
        String dataGeracao = ToolDate.dateToStr((Date)dataMovimentacao, (String)"yyyyMMddHHmmss");
        String seq = ToolString.completaZeros((String)String.valueOf(nrSeq), (int)5, (boolean)true);
        String tipoInscricao = opcoesReinf.getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId()) ? "1" : "2";
        return id + tipoInscricao + numeroTpsInscricao + dataGeracao.substring(0, 14) + seq;
    }

    public static XMLGregorianCalendar converteData(Date dataDocumento) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dataDocumento);
            return DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
    }

    public static String getTipoInscricaoEmpregador(Short tipoPessoa) {
        if (tipoPessoa.equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            return "1";
        }
        return "2";
    }
}

