/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v2.WebReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoConsultatV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaUdpateResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoResultInsertV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoUpdateResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.web.ToolWebResponse;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.stereotype.Component;

@Component
public class WebReceitaAgronomoV2
extends WebReceitaV2<DTOAgronomoResultInsertV2> {
    private static final String URL = "https://www.novoreceituarioagronomico.com.br/api/profissionais/";
    private static final String URL_CONSULTA_INSCRICAO = "https://www.novoreceituarioagronomico.com.br/api/profissionais/?inscricao__iexact={0}";
    private static final String URL_ATUALIZACAO = "https://www.novoreceituarioagronomico.com.br/api/profissionais/{0}/";
    private static final String URL_ART = "https://www.novoreceituarioagronomico.com.br/api/arts/";
    private static final String URL_ART_ATUALIZACAO = "https://www.novoreceituarioagronomico.com.br/api/arts/{0}/";
    private static final String URL_CREA = "https://www.novoreceituarioagronomico.com.br/api/creas/";
    private static final String URL_CREA_ATUALIZACAO = "https://www.novoreceituarioagronomico.com.br/api/creas/{0}/";
    private static final String URL_CERTIFICADO_DIGITAL = "https://www.novoreceituarioagronomico.com.br/api/profissionais/certificado-digital/{0}/";

    public DTOAgronomoResultInsertV2 cadastrarAgronomo(WebReceitaConfig config, DTOAgronomoV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL, config.getSenha(), DTOAgronomoResultInsertV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoConsultatV2 consultarTecnico(WebReceitaConfig config, String inscricao) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL(URL_CONSULTA_INSCRICAO, inscricao);
            List<DTOAgronomoConsultatV2> ret = this.buildAndGetList(url, config.getSenha(), DTOAgronomoConsultatV2.class);
            if (ret.size() > 0) {
                return ret.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoUpdateResV2 atualizarAgronomo(WebReceitaConfig config, DTOAgronomoUpdateV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL(URL_ATUALIZACAO, dto.getId());
            return this.putAndGetOne(url, config.getSenha(), DTOAgronomoUpdateResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoARTResV2 cadastrarART(WebReceitaConfig config, DTOAgronomoARTV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL_ART, config.getSenha(), DTOAgronomoARTResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoARTResV2 atualizarART(WebReceitaConfig config, DTOAgronomoARTUpdateV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.putAndGetOne(this.prepareURL(URL_ART_ATUALIZACAO, dto.getId()), config.getSenha(), DTOAgronomoARTResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public void cadastrarCertificado(WebReceitaConfig config, Long idAgronomo, byte[] certificateData) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            String tempUrl = ToolString.formatMessage((String)URL_CERTIFICADO_DIGITAL, (Object[])new Object[]{idAgronomo});
            File temp = ToolFile.createTempFile((String)"cert", (String)".pfx");
            ToolFile.writeBytesOnFile((File)temp, (byte[])certificateData);
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("arquivo_certificado", "setup.pfx", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (String)temp.getAbsolutePath())).build();
            Request request = new Request.Builder().url(tempUrl).addHeader("Authorization", "Bearer " + config.getSenha()).method("PUT", (RequestBody)body).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                throw new ExceptionValidacaoDados("01-02-00718", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage()});
            }
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoCreaResV2 cadastrarCrea(WebReceitaConfig webConfig, DTOAgronomoCreaV2 dto) throws ExceptionIO {
        try {
            return this.postAndGetOne(URL_CREA, webConfig.getSenha(), DTOAgronomoCreaResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoCreaUdpateResV2 atualizarCrea(WebReceitaConfig webConfig, DTOAgronomoCreaUpdateV2 dto) throws ExceptionIO {
        try {
            return this.putAndGetOne(this.prepareURL(URL_CREA_ATUALIZACAO, dto.getId()), webConfig.getSenha(), DTOAgronomoCreaUdpateResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaAgronomoV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

