/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.cte;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public enum EnumConstCTeStatus {
    CTE_CRIADO_NAO_ENV(0, "CT-e criado, nao enviada"),
    AUTORIZADO(100, "Autorizado o uso da CT-e"),
    CANCELADO(101, "Cancelamento de CT-e homologado"),
    INUTILIZADO(102, "Inutiliza\u00e7\u00e3o de n\u00famero homologado"),
    LOTE_RECEBIDO(103, "Lote recebido com sucesso"),
    LOTE_PROCESSADO(104, "Lote processado"),
    LOTE_EM_PROCESSAMENTO(105, "Lote em processamento"),
    LOTE_NAO_LOCALIZADO(106, "Lote n\u00e3o localizado"),
    SERVICO_EM_OPERACAO(107, "Servi\u00e7o em Opera\u00e7\u00e3o"),
    SERVICO_PARALIZADO_CURTO_PRAZO(108, "Servi\u00e7o Paralisado Momentaneamente (curto prazo)"),
    SERVICO_PARALIZADO_SEM_PREVISAO(109, "Servi\u00e7o Paralisado sem Previs\u00e3o"),
    DENEGADA(110, "Uso Denegado"),
    CONSULTA_CADASTRO_UMA_OCORRENCIA(111, "Consulta cadastro com uma ocorrencia"),
    CONSULTA_CADASTRO_MAIS_OCORRENCIA(112, "Consulta cadastro com mais de uma ocorrencia"),
    SERVICO_SVC_OPERACAO(113, "Servi\u00e7o SVC em operacao"),
    SERVICO_SVC_DESABILITADO(114, "Servi\u00e7o SVC desabilitado pela Sefaz de Origem"),
    EVENTO_REGISTRADO_VINC_CTE_ALERTA(134, "Evento registrado e vinculado ao CT-e com alerta para situa\u00e7\u00e3o do documento."),
    EVENTO_REGISTRADO_VINC_CTE(135, "Evento registrado e vinculado a CT-e"),
    EVENTO_REGISTRADO_NAO_VINC_CTE(136, "Evento registrado mas n\u00e3o vinculado ao CT-e"),
    REJ_DUPLICIDADE_CTE(204, "Duplicidade de CTe."),
    REJ_FALHA_SCHEMA_XML(215, "Rejei\u00e7\u00e3o: Falha no schema XML"),
    REJ_DUPLICIDADE_CTE_DIF_CHAVE(539, "Duplicidade de CTe com diferen\u00e7a chave acesso.");

    private final Integer value;
    private final String descricao;

    private EnumConstCTeStatus(Integer value, String descricao) {
        this.value = value;
        this.descricao = descricao;
    }

    public static boolean isStatusDenegado(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusDenegado(aux);
    }

    public static boolean isStatusDenegado(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.getStatusDenegado().contains((Object)status);
    }

    public static List<EnumConstCTeStatus> getStatusDenegado() {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{DENEGADA};
        return Arrays.asList(aux);
    }

    public static boolean isStatusAutorizado(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusAutorizado(aux);
    }

    public static boolean isStatusAutorizado(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.getStatusAutorizado().contains((Object)status);
    }

    public static List<EnumConstCTeStatus> getStatusAutorizado() {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{AUTORIZADO};
        return Arrays.asList(aux);
    }

    public static List<EnumConstCTeStatus> getStatusInutilizado() {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{INUTILIZADO};
        return Arrays.asList(aux);
    }

    public static boolean isStatusAutorizadoOuContigencia(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusAutorizadoOuContigencia(aux);
    }

    public static boolean isStatusAutorizadoOuContigencia(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.getStatusAutorizadoOuContigencia().contains((Object)status);
    }

    public static List<EnumConstCTeStatus> getStatusAutorizadoOuContigencia() {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{AUTORIZADO};
        return Arrays.asList(aux);
    }

    public static boolean isStatusCancelado(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusCancelado(aux);
    }

    public static boolean isStatusCancelado(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.getStatusCancelado().contains((Object)status);
    }

    public static List<EnumConstCTeStatus> getStatusCancelado() {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{CANCELADO};
        return Arrays.asList(aux);
    }

    public static List<EnumConstCTeStatus> getStatusNFeAnuladas() {
        LinkedList<EnumConstCTeStatus> status = new LinkedList<EnumConstCTeStatus>();
        status.addAll(EnumConstCTeStatus.getStatusCancelado());
        status.addAll(EnumConstCTeStatus.getStatusInutilizado());
        status.addAll(EnumConstCTeStatus.getStatusDenegado());
        return status;
    }

    public static boolean isStatusInutilizado(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusInutilizado(aux);
    }

    public static boolean isStatusInutilizado(String status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusInutilizado(aux);
    }

    public static boolean isStatusInutilizado(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.getStatusInutilizado().contains((Object)status);
    }

    public static boolean isStatusFinal(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusFinal(aux);
    }

    public static boolean isStatusFinal(EnumConstCTeStatus status) {
        if (status == null) {
            return false;
        }
        if (EnumConstCTeStatus.isStatusDenegado(status)) {
            return true;
        }
        if (EnumConstCTeStatus.isStatusCancelado(status)) {
            return true;
        }
        if (EnumConstCTeStatus.isStatusAutorizado(status)) {
            return true;
        }
        return EnumConstCTeStatus.isStatusInutilizado(status);
    }

    public static EnumConstCTeStatus[] getStatusFinal() {
        LinkedList<EnumConstCTeStatus> status = new LinkedList<EnumConstCTeStatus>();
        status.addAll(EnumConstCTeStatus.getStatusAutorizado());
        status.addAll(EnumConstCTeStatus.getStatusCancelado());
        status.addAll(EnumConstCTeStatus.getStatusDenegado());
        status.addAll(EnumConstCTeStatus.getStatusInutilizado());
        return status.toArray(new EnumConstCTeStatus[0]);
    }

    public static boolean isRejeitadaOuNaoEnv(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitadaOuNaoEnv(Integer status) {
        if (status == null) {
            return true;
        }
        return status < 10 || status >= 200;
    }

    public static boolean isRejeitada(EnumConstCTeStatus status) {
        return EnumConstCTeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitada(Integer status) {
        if (status == null) {
            return true;
        }
        return status >= 200;
    }

    public static EnumConstCTeStatus getByCodigo(String value) {
        EnumConstCTeStatus[] values;
        for (EnumConstCTeStatus value1 : values = EnumConstCTeStatus.values()) {
            if (!Objects.equals(value1.getValue(), Integer.valueOf(value))) continue;
            return value1;
        }
        return null;
    }

    public static EnumConstCTeStatus getByCodigo(Integer value) {
        return EnumConstCTeStatus.getByCodigo(value.toString());
    }

    public Integer getValue() {
        return this.value;
    }

    public Short getValueShort() {
        return this.value.shortValue();
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static boolean isStatusDuplicidade(Integer status) {
        EnumConstCTeStatus aux = EnumConstCTeStatus.getByCodigo(status);
        return EnumConstCTeStatus.isStatusAutorizado(aux);
    }

    public static boolean isStatusDuplicidade(EnumConstCTeStatus status) {
        EnumConstCTeStatus[] aux = new EnumConstCTeStatus[]{REJ_DUPLICIDADE_CTE, REJ_DUPLICIDADE_CTE_DIF_CHAVE};
        return Arrays.asList(aux).contains((Object)status);
    }
}

