/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfe;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public enum EnumConstNFeStatus {
    NFCE_CRIADA_NAO_ENV(0, "NF-e criada, nao enviada"),
    NFCE_CRIADA(1, "NF-e criada"),
    NFCE_CRIADA_ENVIADA_SEM_RET(11, "NF-e enviada sem retorno"),
    NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO(21, "NF-e em Contigencia, sem autorizacao"),
    AUTORIZADA(100, "Autorizado o uso da NF-e"),
    CANCELADA(101, "Cancelamento de NF-e homologado"),
    INUTILIZADA(102, "Inutiliza\u00e7\u00e3o de n\u00famero homologado"),
    LOTE_RECEBIDO(103, "Lote recebido com sucesso"),
    LOTE_PROCESSADO(104, "Lote processado"),
    LOTE_EM_PROCESSAMENTO(105, "Lote em processamento"),
    LOTE_NAO_LOCALIZADO(106, "Lote n\u00e3o localizado"),
    SERVICO_EM_OPERACAO(107, "Servi\u00e7o em Opera\u00e7\u00e3o"),
    SERVICO_PARALIZADO_CURTO_PRAZO(108, "Servi\u00e7o Paralisado Momentaneamente (curto prazo)"),
    SERVICO_PARALIZADO_SEM_PREVISAO(109, "Servi\u00e7o Paralisado sem Previs\u00e3o"),
    DENEGADA(110, "Uso Denegado"),
    DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE(240, "Cancelamento/Inutiliza\u00e7\u00e3o - Irregularidade Fiscal do Emitente"),
    DENEGADA_IRREGULARIDADE_EMITENTE(301, "Cancelamento/Inutiliza\u00e7\u00e3o - Irregularidade fiscal do emitente"),
    DENEGADA_IRREGULARIDADE_DESTINATARIO(302, "Cancelamento/Inutiliza\u00e7\u00e3o - Irregularidade fiscal do destinat\u00e1rio"),
    DENEGADA_IRREGULARIDADE_DESTINATARIO_NAO_HABILITADO(303, "Cancelamento/Inutiliza\u00e7\u00e3o - Irregularidade fiscal do destinat\u00e1rio n\u00e3o habilitado"),
    CONSULTA_COM_UMA_OCORRENCIA(111, "Consulta cadastro com uma ocorr\u00eancia"),
    CONSULTA_COM_MAIS_UMA_OCORRENCIA(112, "Consulta cadastro com mais de uma ocorr\u00eancia"),
    EPEC_AUTORIZADO(124, "EPEC Autorizado"),
    LOTE_EVENTOS_PROCESSADO(128, "Lote de Evento Processado"),
    EVENTO_REG_VINC_NFE(135, "Evento registrado e vinculado a NF-e"),
    EVENTO_REG_NAO_VINC_NFE(136, "Evento registrado, mas n\u00e3o vinculado a NF-e"),
    NENHUM_DOC_LOCALIZADO(137, "Nenhum documento localizado para o Destinat\u00e1rio"),
    DOCUMENTO_LOCALIZADO(138, "Documento localizado para o Destinat\u00e1rio"),
    PEDIDO_DOWNLOAD_PROCESSADO(139, "Pedido de Download processado"),
    DOWNLOAD_DISPONIBILIZADO(140, "Download disponibilizado"),
    AMBIENTE_CONT_EPEC_BLOQ_EMITENTE(142, "Ambiente de Conting\u00eancia EPEC bloqueado para o Emitente"),
    AUTORIZADA_FORA_PRAZO(150, "Autorizado o uso da NF-e, autoriza\u00e7\u00e3o fora de prazo"),
    CANCELADA_FORA_DO_PRAZO(151, "Cancelamento de NF-e homologado fora de prazo"),
    REJ_NR_MAX_INUTILIZACAO_ATINGIDO(201, "Rejei\u00e7\u00e3o: N\u00famero m\u00e1ximo de numera\u00e7\u00e3o a inutilizar ultrapassou o limite"),
    REJ_FALHA_REC_AUTORIA_INT_CERTIFICADO_DIG(202, "Rejei\u00e7\u00e3o: Falha no reconhecimento da autoria ou integridade do arquivo digital"),
    REJ_EMISSOR_NAO_HABILITADO(203, "Rejei\u00e7\u00e3o: Emissor n\u00e3o habilitado para emiss\u00e3o de NF-e"),
    REJ_DUPLICIDADE_NFE(204, "Duplicidade de NF-e"),
    REJ_NFE_DENEGADA_SEFAZ(205, "NF-e est\u00e1 denegada na base de dados da SEFAZ"),
    REJ_NFE_INUTILIZADA_SEFAZ(206, "Rejei\u00e7\u00e3o: NF-e j\u00e1 est\u00e1 inutilizada na Base de dados da SEFAZ"),
    REJ_CNPJ_EMIT_INVALIDO(207, "Rejei\u00e7\u00e3o: CNPJ do emitente inv\u00e1lido"),
    REJ_CNPJ_DESTINATARIO_INVALIDA(208, "Rejei\u00e7\u00e3o: CNPJ do destinat\u00e1rio inv\u00e1lido"),
    REJ_IE_EMITENTE_INVALIDA(209, "Rejei\u00e7\u00e3o: IE do emitente inv\u00e1lida"),
    REJ_IE_DESTINATARIO_INVALIDA(210, "Rejei\u00e7\u00e3o: IE do destinat\u00e1rio inv\u00e1lida"),
    REJ_IE_SUBSTITUTO_INVALIDA(211, "Rejei\u00e7\u00e3o: IE do substituto inv\u00e1lida"),
    REJ_DATA_EMISSAO_POSTERIOR_REC(212, "Rejei\u00e7\u00e3o: Data de emiss\u00c3\u00a3o NF-e posterior a data de recebimento"),
    REJ_CNPJ_AUTOR_DIFERE_CERTIFICADO(213, "Rejei\u00e7\u00e3o: CNPJ-Base do Autor difere do CNPJ-Base do Certificado Digital"),
    REJ_TAMANHO_MENSAGEM_EXCEDIDO(214, "Rejei\u00e7\u00e3o: Tamanho da mensagem excedeu o limite estabelecido"),
    REJ_FALHA_SCHEMA_XML(215, "Rejei\u00e7\u00e3o: Falha no schema XML"),
    REJ_CHAVE_ACESSO_DIF_CADASTRADA(216, "Rejei\u00e7\u00e3o: Chave de Acesso difere da cadastrada"),
    REJ_NFE_NAO_CONSTA_BASE_DADOS_SEFAZ(217, "Rejei\u00e7\u00e3o: NF-e n\u00e3o consta na base de dados da SEFAZ"),
    REJ_NFE_CANCELADA_BASE_DADOS_SEFAZ(218, "NF-e j\u00e1 est\u00e1 cancelada na base de dados da SEFAZ"),
    REJ_CIRCULACAO_NFE_VERIFICADA(219, "Rejei\u00e7\u00e3o: Circula\u00e7\u00e3o da NF-e verificada"),
    REJ_PRAZO_CANCELAMENTO_SUPERIOR_PREVISTO(220, "Rejei\u00e7\u00e3o: Prazo de Cancelamento superior ao previsto na Legisla\u00e7\u00e3o"),
    REJ_CONFIRMADO_RECB_DESTINATARIO(221, "Rejei\u00e7\u00e3o: Confirmado o recebimento da NF-e pelo destinat\u00e1rio"),
    REJ_PROT_AUTORIZACAO_DIFERE_CADASTRADO(222, "Rejei\u00e7\u00e3o: Protocolo de Autoriza\u00e7\u00e3o de Uso difere do cadastrado"),
    REJ_CNPJ_TRANS_LOTE_DIF_CNPJ_TRANS_CONSULTA(223, "Rejei\u00e7\u00e3o: CNPJ do transmissor do lote difere do CNPJ do transmissor da consulta"),
    REJ_FAIXA_INICIAL_MAIOR_FAIXA_FINAL(224, "Rejei\u00e7\u00e3o: A faixa inicial \u00e9 maior que a faixa final"),
    REJ_FALHA_SCHEMA_LOTE_NFE(225, "Rejei\u00e7\u00e3o: Falha no Schema XML do lote de NFe"),
    REJ_CODIGO_UF_EMITENTE_DIVERGE_UF_AUTORIZADORA(226, "Rejei\u00e7\u00e3o: C\u00f3digo da UF do Emitente diverge da UF autorizadora"),
    REJ_ERRO_CHAVE_ACESSO_ID_FALTA_NFE(227, "Rejei\u00e7\u00e3o: Erro na Chave de Acesso - Campo Id - falta a literal NFe"),
    REJ_DATA_EMISSAO_MUITO_ATRASADA(228, "Rejei\u00e7\u00e3o: Data de Emiss\u00e3o muito atrasada"),
    REJ_IE_EMITENTE_NAO_INFORMADA(229, "Rejei\u00e7\u00e3o: IE do emitente n\u00e3o informada"),
    REJ_IE_EMITENTE_NAO_CADASTRADA(230, "Rejei\u00e7\u00e3o: IE do emitente n\u00e3o cadastrada"),
    REJ_ERRO_CHAVE_ACESSO_CAMPO_ID(502, "Rejei\u00e7\u00e3o: Erro na Chave de Acesso - Campo Id n\u00e3o corresponde \u00e0 concatena\u00e7\u00e3o dos campos correspondentes"),
    REJ_INUTILIZACAO_JA_EXISTENTE(563, "Rejei\u00e7\u00e3o: Inutilizacao com a faixa de numero j\u00e1 utilizada");

    private final Integer value;
    private final String descricao;

    private EnumConstNFeStatus(Integer value, String descricao) {
        this.value = value;
        this.descricao = descricao;
    }

    public static boolean isStatusDenegada(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusDenegada(aux);
    }

    public static boolean isStatusDenegada(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.getStatusDenegada().contains((Object)status);
    }

    public static List<EnumConstNFeStatus> getStatusDenegada() {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{DENEGADA, REJ_NFE_DENEGADA_SEFAZ, DENEGADA, DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE, DENEGADA_IRREGULARIDADE_DESTINATARIO_NAO_HABILITADO, DENEGADA_IRREGULARIDADE_DESTINATARIO, DENEGADA_IRREGULARIDADE_EMITENTE};
        return Arrays.asList(aux);
    }

    public static boolean isStatusAutorizada(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusAutorizada(aux);
    }

    public static boolean isStatusAutorizada(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.getStatusAutorizada().contains((Object)status);
    }

    public static List<Short> getStatusAutorizadaShort() {
        Short[] aux = new Short[]{AUTORIZADA.getValueShort(), AUTORIZADA_FORA_PRAZO.getValueShort()};
        return Arrays.asList(aux);
    }

    public static List<Integer> getStatusAutorizadaInteger() {
        Integer[] aux = new Integer[]{AUTORIZADA.getValue(), AUTORIZADA_FORA_PRAZO.getValue()};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFeStatus> getStatusAutorizada() {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{AUTORIZADA, AUTORIZADA_FORA_PRAZO};
        return Arrays.asList(aux);
    }

    public static List<String> getStatusInutilizadaString() {
        String[] aux = new String[]{String.valueOf(INUTILIZADA.getValueShort())};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFeStatus> getStatusInutilizada() {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{INUTILIZADA};
        return Arrays.asList(aux);
    }

    public static boolean isStatusAutorizadaOuContigencia(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusAutorizadaOuContigencia(aux);
    }

    public static boolean isStatusAutorizadaOuContigencia(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.getStatusAutorizadaOuContigencia().contains((Object)status);
    }

    public static List<EnumConstNFeStatus> getStatusAutorizadaOuContigencia() {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{AUTORIZADA, AUTORIZADA_FORA_PRAZO, NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO};
        return Arrays.asList(aux);
    }

    public static boolean isStatusCancelada(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusCancelada(aux);
    }

    public static boolean isStatusCancelada(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.getStatusCancelada().contains((Object)status);
    }

    public static List<Short> getStatusCanceladaShort() {
        Short[] aux = new Short[]{CANCELADA.getValueShort(), CANCELADA_FORA_DO_PRAZO.getValueShort()};
        return Arrays.asList(aux);
    }

    public static List<Integer> getStatusCanceladaInteger() {
        Integer[] aux = new Integer[]{CANCELADA.getValue(), CANCELADA_FORA_DO_PRAZO.getValue()};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFeStatus> getStatusCancelada() {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{CANCELADA, CANCELADA_FORA_DO_PRAZO};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFeStatus> getStatusNFeAnuladas() {
        LinkedList<EnumConstNFeStatus> status = new LinkedList<EnumConstNFeStatus>();
        status.addAll(EnumConstNFeStatus.getStatusCancelada());
        status.addAll(EnumConstNFeStatus.getStatusInutilizada());
        status.addAll(EnumConstNFeStatus.getStatusDenegada());
        return status;
    }

    public static boolean isStatusInutilizada(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusInutilizada(aux);
    }

    public static boolean isStatusInutilizada(String status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusInutilizada(aux);
    }

    public static boolean isStatusInutilizada(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.getStatusInutilizada().contains((Object)status);
    }

    public static boolean isStatusFinal(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusFinal(aux);
    }

    public static boolean isStatusFinal(EnumConstNFeStatus status) {
        if (status == null) {
            return false;
        }
        if (EnumConstNFeStatus.isStatusDenegada(status)) {
            return true;
        }
        if (EnumConstNFeStatus.isStatusCancelada(status)) {
            return true;
        }
        if (EnumConstNFeStatus.isStatusAutorizada(status)) {
            return true;
        }
        return EnumConstNFeStatus.isStatusInutilizada(status);
    }

    public static EnumConstNFeStatus[] getStatusFinal() {
        return EnumConstNFeStatus.getStatusFinalList().toArray(new EnumConstNFeStatus[0]);
    }

    public static List<EnumConstNFeStatus> getStatusFinalList() {
        LinkedList<EnumConstNFeStatus> status = new LinkedList<EnumConstNFeStatus>();
        status.addAll(EnumConstNFeStatus.getStatusAutorizada());
        status.addAll(EnumConstNFeStatus.getStatusCancelada());
        status.addAll(EnumConstNFeStatus.getStatusDenegada());
        status.addAll(EnumConstNFeStatus.getStatusInutilizada());
        return status;
    }

    public static boolean isRejeitadaOuNaoEnv(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitadaOuNaoEnv(Integer status) {
        if (status == null) {
            return true;
        }
        return status < 10 || status >= 200;
    }

    public static boolean isRejeitada(EnumConstNFeStatus status) {
        return EnumConstNFeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitada(Integer status) {
        if (status == null) {
            return true;
        }
        return status >= 200;
    }

    public static EnumConstNFeStatus getByCodigo(String value) {
        EnumConstNFeStatus[] values;
        for (EnumConstNFeStatus value1 : values = EnumConstNFeStatus.values()) {
            if (!Objects.equals(String.valueOf(value1.getValue()), String.valueOf(value))) continue;
            return value1;
        }
        return null;
    }

    public static EnumConstNFeStatus getByCodigo(Integer value) {
        return EnumConstNFeStatus.getByCodigo(value.toString());
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static boolean isStatusDuplicidade(Integer status) {
        EnumConstNFeStatus aux = EnumConstNFeStatus.getByCodigo(status);
        return EnumConstNFeStatus.isStatusAutorizada(aux);
    }

    public static boolean isStatusDuplicidade(EnumConstNFeStatus status) {
        EnumConstNFeStatus[] aux = new EnumConstNFeStatus[]{REJ_DUPLICIDADE_NFE};
        return Arrays.asList(aux).contains((Object)status);
    }

    public Short getValueShort() {
        return this.value.shortValue();
    }
}

