/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorenderecos;

import com.touchcomp.basementorenderecos.model.BairroEnd;
import com.touchcomp.basementorenderecos.model.CidadeEnd;
import com.touchcomp.basementorenderecos.model.LogradouroEnd;
import com.touchcomp.basementorenderecos.model.PaisEnd;
import com.touchcomp.basementorenderecos.model.UnidadeFederativaEnd;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class ConfHibernateEnderecos {
    private static final TLogger logger = TLogger.get(ConfHibernateEnderecos.class);
    @Autowired
    private Environment environment;
    private static String urlConexaoLocal;
    private static String dbUserLocal;
    private static String dbPassLocal;
    private static String dbDriverLocal;
    private static String showSQLLocal;

    @Bean(name={"sessionFactoryEnderecos"})
    public LocalSessionFactoryBean sessionFactoryEnderecos() throws ExceptionReflection {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        sessionFactory.setDataSource(this.dataSourceEnderecos());
        sessionFactory.setAnnotatedClasses(this.getAllClasses());
        sessionFactory.setHibernateProperties(this.getHibernateProps());
        return sessionFactory;
    }

    private Class[] getAllClasses() throws ExceptionReflection {
        LinkedList<Class<UnidadeFederativaEnd>> all = new LinkedList<Class<UnidadeFederativaEnd>>();
        all.add(BairroEnd.class);
        all.add(CidadeEnd.class);
        all.add(LogradouroEnd.class);
        all.add(PaisEnd.class);
        all.add(UnidadeFederativaEnd.class);
        return all.toArray(new Class[0]);
    }

    private Properties getHibernateProps() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.environment.getRequiredProperty("hibernate.dialect"));
        if (TMethods.isStrWithData((String)showSQLLocal)) {
            properties.put("hibernate.show_sql", showSQLLocal);
        }
        properties.put("hibernate.hbm2ddl.auto", this.environment.getRequiredProperty("hibernate.hbm2ddl.auto"));
        properties.put("hibernate.enable_lazy_load_no_trans", "true");
        properties.put("hibernate.id.new_generator_mappings", "false");
        properties.put("hibernate.event.merge.entity_copy_observer", "allow");
        return properties;
    }

    @Bean
    public DataSource dataSourceEnderecos() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(dbDriverLocal);
        dataSource.setUrl(urlConexaoLocal);
        dataSource.setUsername(dbUserLocal);
        dataSource.setPassword(dbPassLocal);
        return dataSource;
    }

    @Bean(name={"transactionManagerEnderecos"})
    @Autowired
    public HibernateTransactionManager transactionManager(@Qualifier(value="sessionFactoryEnderecos") SessionFactory sessionFactoryEnderecos) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactoryEnderecos);
        return txManager;
    }

    public static void setConfig(String dbDriver, String urlConexao, String dbUser, String dbPass, String showSQL) {
        urlConexaoLocal = urlConexao;
        dbUserLocal = dbUser;
        dbPassLocal = dbPass;
        dbDriverLocal = dbDriver;
        showSQLLocal = showSQL;
    }
}

