/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCustodiaCheque;
import com.touchcomp.basementor.model.vo.RemessaCnabCustodiaCheque;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorfiles.cnabs.impl.bancobrasil.cheque.LayoutRemessaBancoBrasilCustodiaCheque240;
import com.touchcomp.basementorfiles.cnabs.interfaces.RemessaCustodiaChequeCnabInterface;
import java.io.File;

public class FilesCnabChequesFactory {
    public static void gerarArquivo(RemessaCnabCustodiaCheque remessa, File file) throws ExceptionIO, ExceptionInvalidData {
        InstituicaoValores instValor = remessa.getInstituicaoValores();
        ConfiguracaoCnab configuracao = null;
        for (ItemRemessaCnabCustodiaCheque i : remessa.getItemRemessaCustodia()) {
            if (i.getItemBorderoCheque().getChequeTerceiros().getConfiguracaoCnab() == null) continue;
            configuracao = i.getItemBorderoCheque().getChequeTerceiros().getConfiguracaoCnab();
            break;
        }
        if (configuracao == null) {
            throw new ExceptionInvalidData("E.ERP.1826.003", new Object[]{instValor});
        }
        RemessaCustodiaChequeCnabInterface custodia = FilesCnabChequesFactory.getInterfaceCustodiaCheque(instValor, configuracao.getLayout());
        custodia.createFile(file, ".txt", remessa.getNumeroSequenciaArquivo(), configuracao);
        custodia.resetCounter();
        custodia.buildHeaderFile(remessa, configuracao);
        custodia.buildHeaderPackage(remessa, configuracao);
        custodia.buildDetail(remessa, configuracao);
        custodia.buildTrailerPackage(configuracao);
        custodia.buildTrailerFile(configuracao);
        custodia.validationBeforePrint();
    }

    private static RemessaCustodiaChequeCnabInterface getInterfaceCustodiaCheque(InstituicaoValores instValor, String layout) throws ExceptionInvalidData {
        switch (layout) {
            case "240": {
                return FilesCnabChequesFactory.getInterfaceRemessaCustodiaCheque240(instValor);
            }
        }
        throw new ExceptionInvalidData("E.ERP.1826.002", new Object[]{instValor});
    }

    private static RemessaCustodiaChequeCnabInterface getInterfaceRemessaCustodiaCheque240(InstituicaoValores instValor) throws ExceptionInvalidData {
        switch (instValor.getNrBanco()) {
            case "001": {
                return new LayoutRemessaBancoBrasilCustodiaCheque240();
            }
        }
        throw new ExceptionInvalidData("E.ERP.1826.001", new Object[]{instValor});
    }
}

