/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs.adapters;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Optional;

public class AdpCnab {
    public String getValueByKey(String errorCode, String key, ConfiguracaoCnab configuracaoCnab) throws ExceptionInvalidData {
        Optional<ItemConfiguracaoCnab> found = configuracaoCnab.getItensConfiguracaoCnab().stream().filter(i -> TMethods.isEquals((Object)key, (Object)i.getChave())).findFirst();
        if (!found.isPresent()) {
            throw new ExceptionInvalidData(errorCode, new Object[]{key});
        }
        ItemConfiguracaoCnab i2 = found.get();
        if (TMethods.isAffirmative((Number)i2.getIsNumerico())) {
            return TString.completaZeros((String)i2.getConteudo(), (int)i2.getTamanho().intValue(), (boolean)true);
        }
        return TString.completaEspacos((String)i2.getConteudo(), (int)i2.getTamanho().intValue(), (boolean)true);
    }

    public String getTipoInscricaoDoisDigitos(String cnpj) {
        if ((cnpj = ToolString.onlyNumbers((String)cnpj)).length() == 14) {
            return "02";
        }
        return "01";
    }

    public String getNumeroDocumento(Short tipoNumero, Titulo titulo, int tamanho) {
        if (TMethods.isNegative((Number)tipoNumero)) {
            return TString.completaEspacos((String)titulo.getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            return TString.completaEspacos((String)titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), (int)tamanho);
        }
        if (titulo.getFaturaCte() != null) {
            return TString.completaEspacos((String)titulo.getFaturaCte().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getRps() != null) {
            return TString.completaEspacos((String)titulo.getRps().getNumero().toString(), (int)tamanho);
        }
        if (titulo.getOrdemCompra() != null) {
            return TString.completaEspacos((String)titulo.getOrdemCompra().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
            return TString.completaEspacos((String)titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getPedidoComercio() != null) {
            return TString.completaEspacos((String)titulo.getPedidoComercio().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getAdiantamentoViagem() != null) {
            return TString.completaEspacos((String)titulo.getAdiantamentoViagem().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getNotaContratoLocacao() != null) {
            return TString.completaEspacos((String)titulo.getNotaContratoLocacao().getNumero().toString(), (int)tamanho);
        }
        if (titulo.getContratoLocacao() != null) {
            return TString.completaEspacos((String)titulo.getContratoLocacao().getNumeroContrato().toString(), (int)tamanho);
        }
        if (titulo.getApuracaoLocacaoContrato() != null) {
            return TString.completaEspacos((String)titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), (int)tamanho);
        }
        if (titulo.getCte() != null) {
            return TString.completaEspacos((String)titulo.getCte().getNumero().toString(), (int)tamanho);
        }
        return TString.completaEspacos((String)titulo.getIdentificador().toString(), (int)tamanho);
    }

    public Endereco getEndereco(String errorCode, Pessoa pessoa) throws ExceptionInvalidData {
        Endereco aux = pessoa.getEnderecoCobranca();
        if (this.checkAddress(aux)) {
            return aux;
        }
        aux = pessoa.getEndereco();
        if (!this.checkAddress(aux)) {
            throw new ExceptionInvalidData(errorCode, new Object[]{pessoa});
        }
        return aux;
    }

    private boolean checkAddress(Endereco enderecoCliente) {
        if (!TMethods.isStrWithData((String)enderecoCliente.getLogradouro())) {
            return false;
        }
        if (!TMethods.isStrWithData((String)enderecoCliente.getNumero())) {
            return false;
        }
        if (!TMethods.isStrWithData((String)enderecoCliente.getBairro())) {
            return false;
        }
        if (!TMethods.isStrWithData((String)enderecoCliente.getCep())) {
            return false;
        }
        if (TMethods.isNull((Object)enderecoCliente.getCidade()).booleanValue()) {
            return false;
        }
        return TMethods.isNull((Object)enderecoCliente.getCidade().getUf()) != false;
    }

    public String getTipoInscricaoUmDigito(String cnpj) {
        if ((cnpj = ToolString.onlyNumbers((String)cnpj)).length() == 14) {
            return "2";
        }
        if (cnpj.length() == 11) {
            return "1";
        }
        return "";
    }

    public boolean isCodigoCMC7(String codigoCMC) {
        if (!ToolMethods.isStrWithData((String)codigoCMC)) {
            return false;
        }
        return codigoCMC.contains("<") && codigoCMC.contains(">");
    }
}

