/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs.adapters;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import java.sql.Timestamp;
import java.util.Date;

public class AdpCnabLine {
    private StringBuilder writter = new StringBuilder();
    private int lineNumber;

    public AdpCnabLine(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void add(String str) {
        if (str == null) {
            str = "";
        }
        this.writter.append(str);
    }

    public void addNotNull(String errorCode, String str) throws ExceptionInvalidData {
        if (str == null) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add(str);
    }

    public void addNotEmpty(String errorCode, String data, int size) throws ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)data)) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        if (data.length() != size) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add(data);
    }

    public void addNotEmpty(String errorCode, String data) throws ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)data)) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add(data);
    }

    public void addSpace(int maxSize) {
        this.addSpace("", maxSize);
    }

    public void addSpace(String data, int maxSize) {
        if (TMethods.isNull((Object)data).booleanValue()) {
            data = "";
        }
        if (data.length() > maxSize) {
            data = data.substring(0, maxSize);
        }
        data = TString.completaEspacos((String)data, (int)maxSize);
        this.add(data);
    }

    public void add0Left(int size) {
        this.add0Left("", size);
    }

    public void addDDMMYY(Date data) {
        String aux = "000000";
        if (data != null) {
            aux = TDate.dateToStr((Date)data, (String)"ddMMyy");
        }
        this.add(aux);
    }

    public void addDDMMYYYY(Date data) {
        String aux = "00000000";
        if (data != null) {
            aux = TDate.dateToStr((Date)data, (String)"ddMMyyyy");
        }
        this.add(aux);
    }

    public void addDDMMYYYY(String errorCode, Date data) throws ExceptionInvalidData {
        if (data == null) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        String aux = "00000000";
        if (data != null) {
            aux = TDate.dateToStr((Date)data, (String)"ddMMyyyy");
        }
        this.add(aux);
    }

    public void addHHmmSS(Timestamp hora) {
        String aux = "000000";
        if (hora != null) {
            aux = TDate.dateToStr((Date)hora, (String)"HHmmss");
        }
        this.add(aux);
    }

    public void add0Left(Double data, int size) {
        data = data != null ? data : 0.0;
        String aux = ToolFormatter.formataNumero((Number)data, (int)2);
        aux = TString.onlyNumbers((String)aux);
        aux = TString.completaZeros((String)aux, (int)size, (boolean)true);
        this.add(aux);
    }

    public void add0Left(Integer data, int size) {
        data = data != null ? data : 0;
        String aux = TString.completaZeros((String)data.toString(), (int)size, (boolean)true);
        this.add(aux);
    }

    public void addComplete0Left(String errorCode, String data, int size) throws ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)data)) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add0Left(data, size);
    }

    public void add0Left(Object data, int size) {
        String aux = String.valueOf(data != null ? data : "");
        aux = TString.completaZeros((String)aux, (int)size, (boolean)true);
        this.add(aux);
    }

    public void add0LeftNotEmpty(String errorCode, String data, int maxSize) throws ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)data)) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add0Left(data, maxSize);
    }

    public void addSpace(String errorCode, String data, int size) throws ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)data)) {
            throw new ExceptionInvalidData(errorCode, new Object[0]);
        }
        this.add0Left(data, size);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    StringBuilder getData() {
        return this.writter;
    }
}

