/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs.adapters;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnabLine;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AdpCnabWriter {
    private File file;
    private PrintWriter writter;
    private File dir;
    private final String filePath;
    private final Integer lineSize;
    private final HashMap<String, Integer> mapLineRegsCounter = new HashMap();
    private final HashMap<String, Double> mapRegsSum = new HashMap();
    private AdpCnabLine currentLine = new AdpCnabLine(1);
    private int totalLines = 0;

    public AdpCnabWriter(String filePath, Integer lineSize) {
        this.filePath = filePath;
        this.lineSize = lineSize;
    }

    public AdpCnabWriter(File dir, String filePath, Integer lineSize) {
        this.filePath = filePath;
        this.dir = dir;
        this.lineSize = lineSize;
    }

    public void createFile() throws ExceptionIO, ExceptionInvalidData {
        this.createFile(null);
    }

    public void createFile(String errorCodeIfExists) throws ExceptionIO, ExceptionInvalidData {
        try {
            this.file = this.dir != null && this.dir.isDirectory() ? new File(this.dir, this.filePath) : new File(this.filePath);
            if (TMethods.isStrWithData((String)errorCodeIfExists) && this.file.exists()) {
                throw new ExceptionInvalidData(errorCodeIfExists, new Object[]{this.file.getAbsolutePath()});
            }
            this.writter = new PrintWriter(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionIO((IOException)ex, new Object[]{this.filePath});
        }
    }

    public void flush() {
        this.writter.flush();
    }

    public void close() {
        this.flush();
        this.writter.close();
    }

    public void println() {
        this.writter.println();
    }

    public void checkFile(String errorCode) throws ExceptionInvalidData, ExceptionIO {
        this.close();
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(this.file));
            int linha = 1;
            while (buffer.ready()) {
                String line = buffer.readLine();
                if (line.length() != this.lineSize.intValue()) {
                    buffer.close();
                    throw new ExceptionInvalidData(errorCode, new Object[]{line.length(), linha});
                }
                ++linha;
            }
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{this.file.getAbsolutePath()});
        }
    }

    public AdpCnabLine newLine() {
        this.currentLine = new AdpCnabLine(this.totalLines + 1);
        return this.currentLine;
    }

    public AdpCnabLine endLine(String reg) {
        this.writter.append(this.currentLine.getData().toString());
        ++this.totalLines;
        this.writter.println();
        this.writter.flush();
        this.countIt(reg);
        return this.newLine();
    }

    public void countIt(String reg) {
        Integer count = this.mapLineRegsCounter.get(reg);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        count = count + 1;
        this.mapLineRegsCounter.put(reg, count);
    }

    public void sumIt(String reg, Double value) {
        Double sum = this.mapRegsSum.get(reg);
        if (sum == null) {
            sum = 0.0;
        }
        sum = sum + value;
        this.mapRegsSum.put(reg, sum);
    }

    public Integer getCount(String reg) {
        Integer count = this.mapLineRegsCounter.get(reg);
        return count != null ? count : 0;
    }

    public Double getSum(String reg) {
        Double sum = this.mapRegsSum.get(reg);
        return sum != null ? sum : 0.0;
    }

    public Integer getAllCount(String reg) {
        Integer count = 0;
        Set<Map.Entry<String, Integer>> values = this.mapLineRegsCounter.entrySet();
        for (Map.Entry<String, Integer> v : values) {
            count = count + v.getValue();
        }
        return count;
    }

    public void resetCounter() {
        this.totalLines = 0;
    }

    public void reset() {
        this.resetCounter();
        this.mapLineRegsCounter.clear();
        this.mapLineRegsCounter.clear();
    }

    public int getNumberOfLines() {
        return this.totalLines;
    }

    public File getFile() {
        return this.file;
    }

    public class Line {
        public Line(AdpCnabWriter this$0) {
        }
    }
}

