/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs.impl.bancobrasil.cheque;

import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCustodiaCheque;
import com.touchcomp.basementor.model.vo.RemessaCnabCustodiaCheque;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnab;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnabLine;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnabWriter;
import com.touchcomp.basementorfiles.cnabs.interfaces.RemessaCustodiaChequeCnabInterface;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.Date;

public class LayoutRemessaBancoBrasilCustodiaCheque240
implements RemessaCustodiaChequeCnabInterface {
    private File arquivo;
    private AdpCnabWriter adpWritter;
    private AdpCnab adpCnab = new AdpCnab();
    private String HEADER = "header";
    private String TRAILER = "trailer";
    private String TRAILER_FILE = "trailerFile";
    private String DETAIL_O = "detailO";
    private String DETAIL_N = "detailN";
    private String HEADER_FILE = "headerFile";
    private String CHEQUES = "cheques";

    @Override
    public File createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        extension = "REM";
        this.adpWritter = new AdpCnabWriter(this.getFileName(extension, numSequencialRemessa), 240);
        this.adpWritter.createFile("E.ERP.1826.004");
        return this.adpWritter.getFile();
    }

    @Override
    public void resetCounter() {
        this.adpWritter.reset();
    }

    @Override
    public void buildHeaderFile(RemessaCnabCustodiaCheque remessaCheque, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        AdpCnabLine line = this.adpWritter.newLine();
        BorderoChequesTerceiros bordero = ((ItemRemessaCnabCustodiaCheque)remessaCheque.getItemRemessaCustodia().get(0)).getItemBorderoCheque().getBorderoChequeTerceiros();
        ContaValores contaValor = bordero.getCarteiraCobranca().getContaValor();
        line.add("001");
        line.add("0000");
        line.add("0");
        line.addSpace(9);
        line.add(this.adpCnab.getTipoInscricaoUmDigito(remessaCheque.getEmpresa().getPessoa().getComplemento().getCnpj()));
        line.add0Left(ToolString.onlyNumbers((String)remessaCheque.getEmpresa().getPessoa().getComplemento().getCnpj()), 14);
        String convenioCustodia = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioCustodiaCheque();
        line.addSpace("E.ERP.1826.005", convenioCustodia, 9);
        line.add("0126");
        line.addSpace(7);
        line.add0Left(contaValor.getAgenciaValor().getNrAgencia(), 5);
        line.addSpace(contaValor.getAgenciaValor().getDvAgencia(), 1);
        line.add0Left(contaValor.getNrConta(), 12);
        line.add0Left(contaValor.getDvConta(), 1);
        line.addSpace(contaValor.getCodigoDac(), 1);
        line.addSpace(remessaCheque.getEmpresa().getPessoa().getNome().toUpperCase(), 30);
        line.addSpace("BANCO DO BRASIL", 30);
        line.addSpace(10);
        line.add("1");
        line.addDDMMYYYY(remessaCheque.getDataCadastro());
        line.addHHmmSS(remessaCheque.getHoraGeracao());
        line.add0Left(remessaCheque.getNumeroSequenciaArquivo(), 6);
        line.add("030");
        line.add("01600");
        line.addSpace(20);
        line.addSpace(20);
        line.addSpace(19);
        line.addSpace(2);
        line.addSpace(8);
        this.adpWritter.endLine(this.HEADER_FILE);
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCustodiaCheque remessaCheque, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        AdpCnabLine line = this.adpWritter.newLine();
        BorderoChequesTerceiros bordero = ((ItemRemessaCnabCustodiaCheque)remessaCheque.getItemRemessaCustodia().get(0)).getItemBorderoCheque().getBorderoChequeTerceiros();
        ContaValores contaValor = bordero.getCarteiraCobranca().getContaValor();
        line.add("001");
        line.add("0001");
        line.add("1");
        line.add("R");
        line.add("07");
        line.add("01");
        line.add("020");
        line.addSpace(1);
        line.add(this.adpCnab.getTipoInscricaoUmDigito(remessaCheque.getEmpresa().getPessoa().getComplemento().getCnpj()));
        line.add0Left(remessaCheque.getEmpresa().getPessoa().getComplemento().getCnpj(), 14);
        line.add0LeftNotEmpty("E.ERP.1826.005", contaValor.getNumeroConvenioCustodiaCheque(), 9);
        line.add("0126");
        line.addSpace(7);
        String agencia = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia();
        String dv = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        if (ToolMethods.isStrWithData((String)bordero.getCarteiraCobranca().getContaValor().getNumeroAgenciaRecepCheque())) {
            agencia = bordero.getCarteiraCobranca().getContaValor().getNumeroAgenciaRecepCheque();
            dv = bordero.getCarteiraCobranca().getContaValor().getDvAgenciaRecepCheque();
        }
        line.add0Left(agencia, 5);
        line.add0Left(dv, 1);
        line.add0Left(remessaCheque.getNumeroSequenciaArquivo().toString(), 6);
        line.add0LeftNotEmpty("E.ERP.1826.006", contaValor.getAgenciaValor().getNrAgencia(), 5);
        line.addSpace(contaValor.getAgenciaValor().getDvAgencia(), 1);
        line.add0LeftNotEmpty("E.ERP.1826.007", bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12);
        String dvContaCorrente = bordero.getCarteiraCobranca().getContaValor().getDvConta();
        line.addNotEmpty("E.ERP.1826.008", dvContaCorrente, 1);
        line.addSpace(bordero.getCarteiraCobranca().getContaValor().getCodigoDac(), 1);
        line.addSpace(remessaCheque.getEmpresa().getPessoa().getNome(), 30);
        line.addDDMMYYYY(remessaCheque.getDataCadastro());
        line.addSpace(6);
        line.addSpace(10);
        line.addSpace(4);
        String logradouro = remessaCheque.getEmpresa().getPessoa().getEndereco().getLogradouro();
        line.addSpace(logradouro, 30);
        line.addSpace(remessaCheque.getEmpresa().getPessoa().getEndereco().getNumero(), 5);
        line.addSpace(remessaCheque.getEmpresa().getPessoa().getEndereco().getComplemento(), 15);
        line.addSpace(remessaCheque.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao(), 20);
        String cep = ToolString.onlyNumbers((String)remessaCheque.getEmpresa().getPessoa().getEndereco().getCep());
        line.add0Left(cep, 8);
        line.add(remessaCheque.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        line.addSpace(8);
        line.addSpace(2);
        line.addSpace(8);
        this.adpWritter.endLine(this.HEADER);
    }

    @Override
    public void buildDetail(RemessaCnabCustodiaCheque remessaCheque, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        for (ItemRemessaCnabCustodiaCheque i : remessaCheque.getItemRemessaCustodia()) {
            if (ToolMethods.isStrWithData((String)i.getItemBorderoCheque().getChequeTerceiros().getCodigoCMC())) {
                this.buildDetailSegmentoN(configuracao, remessaCheque, i);
                this.adpWritter.sumIt(this.CHEQUES, i.getItemBorderoCheque().getChequeTerceiros().getValor());
                this.adpWritter.countIt(this.CHEQUES);
                continue;
            }
            throw new ExceptionInvalidData("E.ERP.1826.009", new Object[]{i.getItemBorderoCheque().getChequeTerceiros()});
        }
    }

    private void buildDetailSegmentoN(ConfiguracaoCnab configuracao, RemessaCnabCustodiaCheque remessaCheque, ItemRemessaCnabCustodiaCheque item) throws ExceptionIO {
        AdpCnabLine line = this.adpWritter.newLine();
        BorderoChequesTerceiros bordero = ((ItemRemessaCnabCustodiaCheque)remessaCheque.getItemRemessaCustodia().get(0)).getItemBorderoCheque().getBorderoChequeTerceiros();
        ChequeTerceiros cheque = item.getItemBorderoCheque().getChequeTerceiros();
        line.add("001");
        line.add("0001");
        line.add("3");
        line.add0Left(this.adpWritter.getCount(this.DETAIL_N) + 1, 5);
        line.add("N");
        line.add("0");
        line.add("02");
        line.addSpace(cheque.getCodigoCMC(), 34);
        line.addSpace(cheque.getCnpjTitular(), 14);
        line.add0Left(cheque.getValor(), 15);
        line.addDDMMYYYY(cheque.getDataVencimento());
        line.addSpace(10);
        line.addSpace(10);
        line.add("000");
        line.add("001");
        line.add0Left(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5);
        line.add0Left(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5);
        line.add0Left(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12);
        line.add0Left(0.0, 15);
        line.add0Left(15);
        line.add0Left(15);
        line.add0Left(49);
        line.add0Left(2);
        line.add0Left(8);
        this.adpWritter.endLine(this.DETAIL_N);
        this.adpWritter.flush();
    }

    private void buildDetailSegmentoO(ConfiguracaoCnab configuracao, RemessaCnabCustodiaCheque remessaCheque, ItemRemessaCnabCustodiaCheque item) throws ExceptionIO {
        AdpCnabLine line = this.adpWritter.newLine();
        BorderoChequesTerceiros bordero = ((ItemRemessaCnabCustodiaCheque)remessaCheque.getItemRemessaCustodia().get(0)).getItemBorderoCheque().getBorderoChequeTerceiros();
        ChequeTerceiros cheque = item.getItemBorderoCheque().getChequeTerceiros();
        ContaValores contaValor = bordero.getCarteiraCobranca().getContaValor();
        line.add("001");
        line.add("0001");
        line.add("3");
        line.add0Left(this.adpWritter.getCount(this.DETAIL_O) + 1, 5);
        line.add("O");
        line.add("0");
        line.add("02");
        String codCompensacao = "001";
        line.add(codCompensacao);
        String banco = cheque.getBanco();
        line.add0Left(banco, 3);
        String agencia = cheque.getAgencia();
        line.add0Left(cheque.getAgencia(), 5);
        int dig = ToolNumber.getDigitoVerificadorMod11((String)(codCompensacao + banco + agencia));
        line.add(String.valueOf(dig));
        line.add0Left(cheque.getContaCorrente(), 12);
        dig = ToolNumber.getDigitoVerificadorMod11((String)cheque.getContaCorrente());
        line.add(String.valueOf(dig));
        line.add0Left(cheque.getNumero().toString(), 6);
        dig = ToolNumber.getDigitoVerificadorMod11((String)cheque.getNumero().toString());
        line.add(String.valueOf(dig));
        line.addSpace(2);
        line.addSpace(cheque.getCnpjTitular(), 14);
        line.add0Left(cheque.getValor(), 15);
        line.addDDMMYYYY(cheque.getDataVencimento());
        line.addSpace(10);
        line.addSpace(10);
        line.add("000");
        line.add("001");
        line.add0Left(contaValor.getAgenciaValor().getNrAgencia(), 5);
        line.add0Left(contaValor.getAgenciaValor().getNrAgencia(), 5);
        line.add0Left(contaValor.getNrConta(), 12);
        line.add0Left(0, 15);
        line.add0Left(0, 15);
        line.add0Left(0, 15);
        line.addSpace(49);
        line.addSpace(2);
        line.addSpace(8);
        this.adpWritter.endLine(this.DETAIL_O);
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao) throws ExceptionIO {
        AdpCnabLine line = this.adpWritter.newLine();
        line.add("001");
        line.add("0001");
        line.add("5");
        line.addSpace(9);
        int countReg = 1 + this.adpWritter.getCount(this.DETAIL_N) + 1;
        line.add0Left(countReg, 6);
        line.add0Left(this.adpWritter.getSum(this.CHEQUES), 18);
        line.add0Left(this.adpWritter.getCount(this.CHEQUES), 6);
        line.addSpace(52);
        line.add0Left(18);
        line.add0Left(18);
        line.add0Left(18);
        line.add0Left(6);
        line.add0Left(18);
        line.addSpace(63);
        this.adpWritter.endLine(this.TRAILER);
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao) throws ExceptionIO {
        AdpCnabLine line = this.adpWritter.newLine();
        line.add("001");
        line.add("9999");
        line.add("9");
        line.addSpace(9);
        line.add0Left(1, 6);
        line.add0Left(this.adpWritter.getNumberOfLines() + 1, 6);
        line.add0Left(1, 6);
        line.addSpace(205);
        this.adpWritter.endLine(this.TRAILER_FILE);
        this.adpWritter.close();
    }

    @Override
    public void validationBeforePrint() throws ExceptionInvalidData, ExceptionIO {
        this.adpWritter.checkFile("error_code");
    }

    @Override
    public File getFile() throws ExceptionIO {
        return this.arquivo;
    }

    private String getFileName(String extension, Long numSequencialRemessa) {
        String name = ToolDate.dateToStr((Date)new Date(), (String)"ddMMHHmm");
        return "BB_" + name + "." + extension;
    }
}

