/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.cnabs.impl.sofisa.recebimento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnab;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnabLine;
import com.touchcomp.basementorfiles.cnabs.adapters.AdpCnabWriter;
import com.touchcomp.basementorfiles.cnabs.interfaces.InterfaceItemRemessaCobranca;
import com.touchcomp.basementorfiles.cnabs.interfaces.InterfaceRemessaCobranca;
import com.touchcomp.basementorfiles.cnabs.interfaces.RemessaRecebimentoCnabInterface;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;

public class LayoutRemessaSofisaRecebimento400
implements RemessaRecebimentoCnabInterface {
    private AdpCnabWriter adpWritter;
    private final AdpCnab adpCnab = new AdpCnab();

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        String dia = ToolString.completaZeros((String)String.valueOf(g.get(5)), (int)2, (boolean)true);
        String mes = ToolString.completaZeros((String)String.valueOf(g.get(2)), (int)2, (boolean)true);
        String fileName = "UGA" + dia + mes + numSequencialRemessa.toString() + "." + extension;
        this.adpWritter = new AdpCnabWriter(fileName, 400);
        this.adpWritter.createFile("arquivo_existe");
    }

    @Override
    public void resetCounter() {
        this.adpWritter.resetCounter();
    }

    @Override
    public void buildHeaderFile(InterfaceRemessaCobranca interfaceRemessaCobranca, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        AdpCnabLine line = this.adpWritter.newLine();
        line.add("0");
        line.add("1");
        line.add("REMESSA");
        line.add("01");
        line.addSpace("COBRANCA", 15);
        line.addSpace(interfaceRemessaCobranca.getNumeroConvenio(), 20);
        line.addSpace(interfaceRemessaCobranca.getNomeEmpresa(), 30);
        line.add("637");
        line.addSpace("BANCO SOFISA SA", 15);
        line.addDDMMYY(interfaceRemessaCobranca.getDataCadastro());
        line.addSpace(294);
        line.add0Left(line.getLineNumber(), 6);
        this.adpWritter.endLine("headerFile");
    }

    @Override
    public void buildHeaderPackage(InterfaceRemessaCobranca interfaceRemessaCobranca, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
    }

    @Override
    public void buildDetail(InterfaceRemessaCobranca interfaceRemessaCobranca, Short tipoNumero, ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        for (InterfaceItemRemessaCobranca interfaceItemRemessaCobranca : interfaceRemessaCobranca.getInterfaceItemRemessaCobranca()) {
            AdpCnabLine line = this.adpWritter.newLine();
            line.add("1");
            line.add(this.adpCnab.getTipoInscricaoDoisDigitos(interfaceRemessaCobranca.getCnpjEmpresa()));
            line.addComplete0Left("error_code", ToolString.onlyNumbers((String)interfaceRemessaCobranca.getCnpjEmpresa()), 14);
            line.addSpace(interfaceRemessaCobranca.getNumeroConvenio(), 20);
            line.addSpace(ToolMethods.isEquals((Object)tipoNumero, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? interfaceItemRemessaCobranca.getNrDocumentoOrigem() : interfaceItemRemessaCobranca.getIdTitulo().toString(), 25);
            line.add0Left(interfaceItemRemessaCobranca.getNumeroTituloInst(), 11);
            line.add0Left(13);
            line.addSpace(3);
            line.add(this.adpCnab.getValueByKey("error_code", "CODIGO_MULTA", configuracao));
            String codMulta = this.adpCnab.getValueByKey("error_codigo", "CODIGO_MULTA", configuracao);
            if (ToolMethods.isEquals((Object)codMulta, (Object)"1")) {
                Double valorMultaFixa = 0.0;
                if (ToolMethods.isWithData((Number)interfaceItemRemessaCobranca.getPercMulta())) {
                    valorMultaFixa = ToolFormatter.arrredondarNumero((Double)(interfaceItemRemessaCobranca.getValor() * (interfaceItemRemessaCobranca.getPercMulta() / 100.0)), (int)2);
                }
                line.add0Left(valorMultaFixa, 13);
            } else if (ToolMethods.isEquals((Object)codMulta, (Object)"2")) {
                line.add0Left(interfaceItemRemessaCobranca.getPercMulta(), 13);
            } else {
                line.add0Left(13);
            }
            line.add(this.adpCnab.getValueByKey("errorcode", "NUMERO_DIAS_MULTA", configuracao));
            line.addSpace(2);
            line.addNotEmpty("error_code", interfaceRemessaCobranca.getCodigoCarteira());
            line.addNotEmpty("error_code", interfaceRemessaCobranca.getCodigoTipoRemessa());
            line.addSpace(interfaceItemRemessaCobranca.getNrDocumentoOrigem(), 10);
            line.addDDMMYY(interfaceItemRemessaCobranca.getDataVencimento());
            line.add0Left(ToolMethods.isWithData((Number)interfaceItemRemessaCobranca.getValorBoleto()) ? interfaceItemRemessaCobranca.getValorBoleto() : interfaceItemRemessaCobranca.getValor(), 13);
            line.add("637");
            line.add0Left(4);
            line.add0Left(1);
            line.add(this.adpCnab.getValueByKey("errorcode", "ESPECIE_TITULO", configuracao));
            line.add(this.adpCnab.getValueByKey("errorcode", "ACEITE", configuracao));
            line.addDDMMYY(interfaceItemRemessaCobranca.getDataEmissao());
            line.add0Left(2);
            line.add0Left(2);
            line.add0Left(interfaceItemRemessaCobranca.getVrJurosDia(), 13);
            line.addDDMMYY(interfaceItemRemessaCobranca.getDataLimiteDesconto());
            line.add0Left(interfaceItemRemessaCobranca.getDescontoFinanceiro() + interfaceItemRemessaCobranca.getValorDescontosEmbutido(), 13);
            line.add0Left(13);
            line.add0Left(interfaceItemRemessaCobranca.getVrAbatimento(), 13);
            line.add(this.adpCnab.getTipoInscricaoDoisDigitos(interfaceItemRemessaCobranca.getCnpjPessoa()));
            line.add0Left(interfaceItemRemessaCobranca.getCnpjPessoa(), 14);
            line.addSpace(interfaceItemRemessaCobranca.getNomePessoa(), 30);
            line.addSpace(10);
            line.addSpace(ToolString.substituiCaractereEspecial((String)(interfaceItemRemessaCobranca.getLogradouro() + " " + interfaceItemRemessaCobranca.getNumero() + " " + interfaceItemRemessaCobranca.getComplemento())), 40);
            line.addSpace(ToolString.substituiCaractereEspecial((String)interfaceItemRemessaCobranca.getBairro()), 12);
            line.add0Left(interfaceItemRemessaCobranca.getCep(), 8);
            line.addSpace(ToolString.substituiCaractereEspecial((String)interfaceItemRemessaCobranca.getCidade()), 15);
            line.addSpace(interfaceItemRemessaCobranca.getSiglaUf(), 2);
            line.addSpace(interfaceRemessaCobranca.getNomeEmpresa(), 30);
            line.addSpace(4);
            line.addSpace(6);
            line.add(this.adpCnab.getValueByKey("errorcode", "PRAZO_PARA_PROTESTO", configuracao));
            line.add(this.adpCnab.getValueByKey("errorcode", "MOEDA", configuracao));
            line.add0Left(line.getLineNumber(), 6);
            line.add0Left(interfaceItemRemessaCobranca.getChaveNfe(), 44);
            this.adpWritter.endLine("detail");
        }
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao) throws ExceptionIO, ExceptionInvalidData {
        AdpCnabLine line = this.adpWritter.newLine();
        line.add("9");
        line.addSpace(393);
        line.add0Left(line.getLineNumber(), 6);
        this.adpWritter.endLine("trailer");
    }

    @Override
    public void validationBeforePrint() throws ExceptionIO, ExceptionInvalidData {
    }

    @Override
    public File getFile() throws ExceptionIO, ExceptionInvalidData {
        return this.adpWritter.getFile();
    }
}

