/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.geracaoarquivosbalancapdv.toledo;

import com.touchcomp.basementor.model.impl.ProdutoPrecos;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.textfile.writter.ToolTextFileWritter;
import com.touchcomp.basementortools.tools.textfile.writter.model.TextLineWritter;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CadastroAndAlteracaoProdutoToledo {
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabelaPrecoBaseImpl;
    public static final short PRODUTO_CODIGO_AUXILIAR = 0;
    public static final short PRODUTO_IDENTIFICADOR = 1;

    public void gerarArquivo(File caminhoArquivo, TabelaPrecoBase tabPrecoBase, Short identificacaoProduto) throws ExceptionIO {
        caminhoArquivo.getParentFile().mkdirs();
        ToolTextFileWritter tool = new ToolTextFileWritter();
        tool.setDecimalSeparator(false);
        tool.setRegisterSeparator("");
        List dados = this.serviceTabelaPrecoBaseImpl.getProdutosVendaFracionados(tabPrecoBase);
        dados.forEach(prod -> this.writeOn(tool, (ProdutoPrecos)prod, identificacaoProduto));
        tool.writeOnOutputStream(caminhoArquivo);
    }

    private void writeOn(ToolTextFileWritter tool, ProdutoPrecos prod, Short identificacaoProduto) {
        String nome = prod.getNome();
        if (ToolMethods.isStrWithData((String)prod.getNomeAuxiliar())) {
            nome = prod.getNomeAuxiliar();
        }
        TextLineWritter line = tool.newLine();
        line.newReg("01");
        line.newReg("00");
        line.newReg("0");
        if (ToolMethods.isEquals((Object)0, (Object)identificacaoProduto)) {
            line.newReg(ToolString.completaZeros((String)prod.getCodigoAuxiliar(), (int)6, (boolean)true));
        } else {
            line.newReg(ToolString.completaZeros((String)prod.getIdProduto().toString(), (int)6, (boolean)true));
        }
        String valor = ToolFormatter.formataNumero((Number)prod.getValorVenda(), (int)2);
        valor = ToolString.onlyNumbers((String)valor);
        valor = ToolString.completaZeros((String)valor, (int)6, (boolean)true);
        line.newReg(valor);
        line.newReg(ToolString.completaZeros((String)prod.getNrDiasValidade().toString(), (int)3, (boolean)true));
        line.newReg(nome).setSize(50);
    }
}

