/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.spedfiscal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.spedfiscal.EnumConstSpedFiscalTpPropEstoque;
import com.touchcomp.basementor.model.vo.InventarioSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorfiles.result.FileResultParser;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.excel.ToolExcel;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.basementorvalidator.others.planoconta.ValidatePlanoConta;
import java.io.File;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilesImportarEstoqueSped {
    @Autowired
    ServiceProdutoImpl serviceProduto;
    @Autowired
    ServicePessoaImpl servicePessoa;
    @Autowired
    ServicePlanoContaImpl servicePlanoConta;
    private final int NR_CELLS = 7;

    public FileResultParser<List<InventarioSped>> importarEstoqueSped(File file, SpedFiscal sped, TipoIdentificacaoProd tipoIdentProd, int linhaIn, int endLine, boolean append) {
        FileResultParser<List<InventarioSped>> fileResult = new FileResultParser<List<InventarioSped>>();
        try {
            this.importarEstoqueSpedInternal(file, sped, tipoIdentProd, fileResult, linhaIn, endLine, append);
            return fileResult;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            fileResult.setStatus(EnumConstantsMentorStatus.ERRO);
            fileResult.setMainMessage(MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.199", (Object[])new Object[]{ex.getMessage()}));
            return fileResult;
        }
    }

    private void importarEstoqueSpedInternal(File file, SpedFiscal sped, TipoIdentificacaoProd tipoIdentProd, FileResultParser<List<InventarioSped>> fileResult, int linhaIn, int endLine, boolean append) throws ExceptionIO, ParseException, ExceptionParseObject {
        ExcelSheet excel = ToolExcel.read((File)file, (int)linhaIn, (int)endLine);
        LinkedList<InventarioSped> aux = new LinkedList();
        if (append) {
            aux = sped.getInventarioSped();
        }
        fileResult.setResult(aux);
        HashMap<String, Pessoa> cachePessoa = new HashMap<String, Pessoa>();
        HashMap<String, PlanoConta> cachePlanoConta = new HashMap<String, PlanoConta>();
        HashMap<String, Produto> cacheProduto = new HashMap<String, Produto>();
        for (ExcelSheet.Row row : excel.getRows()) {
            System.out.println("Importando linha " + row.getIndex());
            this.importarLinha(row, sped, tipoIdentProd, fileResult, aux, cachePessoa, cacheProduto, cachePlanoConta, append);
        }
    }

    private Produto getProduto(Map<String, Produto> cacheProduto, String codProduto, TipoIdentificacaoProd tipoIdentProd) {
        Produto prod = cacheProduto.get(codProduto);
        if (prod != null) {
            return prod;
        }
        switch (tipoIdentProd.ordinal()) {
            case 1: {
                prod = this.serviceProduto.getByCodigoAuxiliar(codProduto);
                break;
            }
            case 2: {
                prod = this.serviceProduto.getByCodigoBarras(codProduto);
                break;
            }
            case 0: {
                prod = (Produto)this.serviceProduto.get(codProduto);
            }
        }
        cacheProduto.put(codProduto, prod);
        return prod;
    }

    private Pessoa getPessoa(Map<String, Pessoa> cachePessoa, String codPessoa) {
        Pessoa p = cachePessoa.get(codPessoa = ToolString.refina((String)codPessoa));
        if (p != null) {
            return p;
        }
        if (ValidadeCPFCNPJ.isCPFCNPJ((String)codPessoa)) {
            p = this.servicePessoa.getByCPFCNPJAtiva(codPessoa);
        } else if (codPessoa.length() < 9) {
            p = (Pessoa)this.servicePessoa.get(codPessoa);
        }
        cachePessoa.put(codPessoa, p);
        return p;
    }

    private PlanoConta getPlanoConta(Map<String, PlanoConta> cachePlanoConta, String codPc) {
        PlanoConta p = cachePlanoConta.get(codPc = ToolString.refina((String)codPc));
        if (p != null) {
            return p;
        }
        p = ValidatePlanoConta.isCodigoPlanoConta((String)codPc) ? this.servicePlanoConta.findByCodigo(codPc) : (PlanoConta)this.servicePlanoConta.get(codPc);
        cachePlanoConta.put(codPc, p);
        return p;
    }

    private EnumConstSpedFiscalTpPropEstoque getIndicadorPropriedade(String cell) {
        EnumConstSpedFiscalTpPropEstoque found = EnumConstSpedFiscalTpPropEstoque.get((Object)cell);
        return found;
    }

    private void importarLinha(ExcelSheet.Row row, SpedFiscal sped, TipoIdentificacaoProd tipoIdentProd, FileResultParser fileResult, List<InventarioSped> aux, Map<String, Pessoa> cachePessoa, Map<String, Produto> cacheProduto, Map<String, PlanoConta> cachePlanoConta, boolean append) throws ParseException, ExceptionParseObject {
        int index = row.getIndex();
        int INDEX_PRODUTO = 1;
        int INDEX_PESSOA = 2;
        int INDEX_PLANO_CONTA = 3;
        int INDEX_IND_PROPRIEDADE = 4;
        int INDEX_QUANTIDADE = 5;
        int INDEX_VLR_UNITARIO = 6;
        int INDEX_DESC_COMP = 7;
        String codProduto = ToolString.onlyNumbers((String)row.getCell(INDEX_PRODUTO).asString());
        String codPessoa = "";
        if (row.getCellsSize() > INDEX_PESSOA) {
            codPessoa = ToolString.onlyNumbers((String)row.getCell(INDEX_PESSOA).asString());
        }
        String codPc = "";
        if (row.getCellsSize() > INDEX_PLANO_CONTA) {
            codPc = ToolString.onlyNumbers((String)row.getCell(INDEX_PLANO_CONTA).asString());
        }
        String quantidadeDesc = "0";
        if (row.getCellsSize() > INDEX_QUANTIDADE) {
            quantidadeDesc = row.getCell(INDEX_QUANTIDADE).asString();
        }
        String vlrUnitarioDesc = "0";
        if (row.getCellsSize() > INDEX_VLR_UNITARIO) {
            vlrUnitarioDesc = row.getCell(INDEX_VLR_UNITARIO).asString();
        }
        String descComp = "";
        if (row.getCellsSize() > INDEX_DESC_COMP) {
            descComp = row.getCell(INDEX_DESC_COMP).asString();
        }
        String indicadorProp = String.valueOf(EnumConstSpedFiscalTpPropEstoque.ESTOQUE_PROPRIO_0.getValue());
        if (row.getCellsSize() > INDEX_IND_PROPRIEDADE) {
            indicadorProp = row.getCell(INDEX_IND_PROPRIEDADE).asString();
        }
        boolean success = true;
        if (!ToolMethods.isStrWithData((String)codProduto)) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.100", (Object[])new Object[]{codProduto}));
            success = false;
        }
        if (!ToolMethods.isStrWithData((String)indicadorProp)) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.102", (Object[])new Object[]{indicadorProp}));
            success = false;
        }
        if (!ToolMethods.isStrWithData((String)codPc)) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.101", (Object[])new Object[]{codPc}));
            success = false;
        }
        if (!ToolMethods.isStrWithData((String)quantidadeDesc)) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.104", (Object[])new Object[]{quantidadeDesc}));
            success = false;
        }
        if (!ToolMethods.isStrWithData((String)vlrUnitarioDesc)) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.105", (Object[])new Object[]{vlrUnitarioDesc}));
            success = false;
        }
        Produto prod = this.getProduto(cacheProduto, codProduto, tipoIdentProd);
        Pessoa pes = this.getPessoa(cachePessoa, codPessoa);
        PlanoConta plan = this.getPlanoConta(cachePlanoConta, codPc);
        EnumConstSpedFiscalTpPropEstoque tipo = this.getIndicadorPropriedade(indicadorProp);
        Double quantidade = row.getCell(INDEX_QUANTIDADE).asDouble();
        Double vlrUnitario = row.getCell(INDEX_VLR_UNITARIO).asDouble();
        if (prod == null) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.100", (Object[])new Object[]{codProduto}));
            success = false;
        }
        if (indicadorProp == null) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.102", (Object[])new Object[]{indicadorProp}));
            success = false;
        }
        if (plan == null) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.101", (Object[])new Object[]{codPc}));
            success = false;
        }
        if (indicadorProp != null && (tipo.equals((Object)EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_MEU_PODER_2) || tipo.equals((Object)EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_PODER_TERCEIROS_1)) && pes == null) {
            fileResult.addError(index, MessagesBaseMentor.getErrorMsg((String)"V.ERP.0394.103", (Object[])new Object[]{codPessoa}));
            success = false;
        }
        if (success) {
            Optional<InventarioSped> found;
            InventarioSped inv = null;
            if (append && (found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getIndicadorPropriedade(), (Object)tipo.getValue()) && ToolMethods.isEquals((Object)i.getPessoa(), (Object)pes) && ToolMethods.isEquals((Object)i.getProduto(), (Object)prod) && ToolMethods.isEquals((Object)i.getPlanoConta(), (Object)plan)).findFirst()).isPresent()) {
                inv = found.get();
            }
            if (inv == null) {
                inv = new InventarioSped();
                aux.add(inv);
            }
            inv.setProduto(prod);
            inv.setPessoa(pes);
            inv.setPlanoConta(plan);
            inv.setIndicadorPropriedade(Short.valueOf(tipo.getValue()));
            inv.setQuantidade(Double.valueOf(quantidade + inv.getQuantidade()));
            inv.setDescricaoComplementar(descComp);
            inv.setSpedFiscal(sped);
            inv.setVlrItem(Double.valueOf(quantidade * vlrUnitario + inv.getVlrItem()));
            inv.setVlrUnitario(vlrUnitario);
        }
    }

    public static enum TipoIdentificacaoProd {
        IDENTIFICADOR("Identificador"),
        CODIGO_AUXILIAR("Cod. Auxiliar"),
        CODIGO_BARRAS("Cod. Barras");

        private final String descricao;

        private TipoIdentificacaoProd(String descricao) {
            this.descricao = descricao;
        }
    }
}

