/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorfiles.terminaisconsultapreco.gertec;

import com.touchcomp.basementor.model.impl.ProdutoPrecos;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.textfile.writter.ToolTextFileWritter;
import com.touchcomp.basementortools.tools.textfile.writter.model.TextLineWritter;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilesGertecAquivoPrecos {
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabelaPrecoBaseImpl;

    public void gerarArquivo(File caminhoArquivo, TabelaPrecoBase tabPrecoBase) throws ExceptionIO {
        caminhoArquivo.getParentFile().mkdirs();
        ToolTextFileWritter tool = new ToolTextFileWritter();
        tool.setRegisterSeparator("|");
        tool.setDecimalSeparator(true);
        List dados = this.serviceTabelaPrecoBaseImpl.getProdutosPrecosCodBarras(tabPrecoBase);
        dados.forEach(prod -> this.writeOn(tool, (ProdutoPrecos)prod));
        tool.writeOnOutputStream(caminhoArquivo);
    }

    private void writeOn(ToolTextFileWritter tool, ProdutoPrecos prod) {
        TextLineWritter line = tool.newLine();
        line.newReg(prod.getCodigoBarras());
        if (ToolMethods.isStrWithData((String)prod.getNomeAuxiliar())) {
            line.newReg(prod.getNomeAuxiliar());
        } else {
            line.newReg(prod.getNome());
        }
        line.newReg(prod.getValorVenda()).setDecimalSize(2);
    }
}

